/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;

public class ZooKeeperCuratorConfiguration
implements Cloneable {
    private CuratorFramework curatorFramework;
    private List<String> nodes;
    private String namespace;
    private long reconnectBaseSleepTime = 1000L;
    private TimeUnit reconnectBaseSleepTimeUnit = TimeUnit.MILLISECONDS;
    private int reconnectMaxRetries = 3;
    private long reconnectMaxSleepTime = Integer.MAX_VALUE;
    private TimeUnit reconnectMaxSleepTimeUnit = TimeUnit.MILLISECONDS;
    private long sessionTimeout = Integer.getInteger("curator-default-session-timeout", 60000).intValue();
    private TimeUnit sessionTimeoutUnit = TimeUnit.MILLISECONDS;
    private long connectionTimeout = Integer.getInteger("curator-default-connection-timeout", 15000).intValue();
    private TimeUnit connectionTimeoutUnit = TimeUnit.MILLISECONDS;
    private List<AuthInfo> authInfoList;
    private long maxCloseWait = 1000L;
    private TimeUnit maxCloseWaitUnit = TimeUnit.MILLISECONDS;
    private RetryPolicy retryPolicy;
    private String basePath;

    public CuratorFramework getCuratorFramework() {
        return this.curatorFramework;
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public void setNodes(String nodes) {
        this.nodes = Arrays.stream(nodes.split(",")).collect(Collectors.toUnmodifiableList());
    }

    public void setNodes(List<String> nodes) {
        this.nodes = Collections.unmodifiableList(new ArrayList<String>(nodes));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public long getReconnectBaseSleepTime() {
        return this.reconnectBaseSleepTime;
    }

    public void setReconnectBaseSleepTime(long reconnectBaseSleepTime) {
        this.reconnectBaseSleepTime = reconnectBaseSleepTime;
    }

    public void setReconnectBaseSleepTime(long reconnectBaseSleepTime, TimeUnit reconnectBaseSleepTimeUnit) {
        this.reconnectBaseSleepTime = reconnectBaseSleepTime;
        this.reconnectBaseSleepTimeUnit = reconnectBaseSleepTimeUnit;
    }

    public TimeUnit getReconnectBaseSleepTimeUnit() {
        return this.reconnectBaseSleepTimeUnit;
    }

    public void setReconnectBaseSleepTimeUnit(TimeUnit reconnectBaseSleepTimeUnit) {
        this.reconnectBaseSleepTimeUnit = reconnectBaseSleepTimeUnit;
    }

    public long getReconnectMaxSleepTime() {
        return this.reconnectMaxSleepTime;
    }

    public void setReconnectMaxSleepTime(long reconnectMaxSleepTime) {
        this.reconnectMaxSleepTime = reconnectMaxSleepTime;
    }

    public void setReconnectMaxSleepTime(long reconnectMaxSleepTime, TimeUnit reconnectBaseSleepTimeUnit) {
        this.reconnectMaxSleepTime = reconnectMaxSleepTime;
        this.reconnectBaseSleepTimeUnit = reconnectBaseSleepTimeUnit;
    }

    public TimeUnit getReconnectMaxSleepTimeUnit() {
        return this.reconnectMaxSleepTimeUnit;
    }

    public void setReconnectMaxSleepTimeUnit(TimeUnit reconnectMaxSleepTimeUnit) {
        this.reconnectMaxSleepTimeUnit = reconnectMaxSleepTimeUnit;
    }

    public int getReconnectMaxRetries() {
        return this.reconnectMaxRetries;
    }

    public void setReconnectMaxRetries(int reconnectMaxRetries) {
        this.reconnectMaxRetries = reconnectMaxRetries;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout, TimeUnit sessionTimeoutUnit) {
        this.sessionTimeout = sessionTimeout;
        this.sessionTimeoutUnit = sessionTimeoutUnit;
    }

    public TimeUnit getSessionTimeoutUnit() {
        return this.sessionTimeoutUnit;
    }

    public void setSessionTimeoutUnit(TimeUnit sessionTimeoutUnit) {
        this.sessionTimeoutUnit = sessionTimeoutUnit;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout, TimeUnit connectionTimeotUnit) {
        this.connectionTimeout = connectionTimeout;
        this.connectionTimeoutUnit = connectionTimeotUnit;
    }

    public TimeUnit getConnectionTimeoutUnit() {
        return this.connectionTimeoutUnit;
    }

    public void setConnectionTimeoutUnit(TimeUnit connectionTimeoutUnit) {
        this.connectionTimeoutUnit = connectionTimeoutUnit;
    }

    public List<AuthInfo> getAuthInfoList() {
        return this.authInfoList;
    }

    public void setAuthInfoList(List<AuthInfo> authInfoList) {
        this.authInfoList = authInfoList;
    }

    public long getMaxCloseWait() {
        return this.maxCloseWait;
    }

    public void setMaxCloseWait(long maxCloseWait) {
        this.maxCloseWait = maxCloseWait;
    }

    public TimeUnit getMaxCloseWaitUnit() {
        return this.maxCloseWaitUnit;
    }

    public void setMaxCloseWaitUnit(TimeUnit maxCloseWaitUnit) {
        this.maxCloseWaitUnit = maxCloseWaitUnit;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public ZooKeeperCuratorConfiguration copy() {
        try {
            return (ZooKeeperCuratorConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

