/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.cluster;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorHelper;
import org.apache.camel.component.zookeeper.cluster.ZooKeeperClusterView;
import org.apache.camel.support.cluster.AbstractCamelClusterService;
import org.apache.camel.util.ObjectHelper;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClusterService
extends AbstractCamelClusterService<ZooKeeperClusterView> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperClusterService.class);
    private CuratorFramework curator;
    private ZooKeeperCuratorConfiguration configuration;
    private boolean managedInstance;

    public ZooKeeperClusterService() {
        this.configuration = new ZooKeeperCuratorConfiguration();
        this.managedInstance = true;
    }

    public ZooKeeperClusterService(ZooKeeperCuratorConfiguration configuration) {
        this.configuration = configuration.copy();
        this.managedInstance = true;
    }

    public ZooKeeperCuratorConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ZooKeeperCuratorConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public CuratorFramework getCuratorFramework() {
        return this.configuration.getCuratorFramework();
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.configuration.setCuratorFramework(curatorFramework);
    }

    public List<String> getNodes() {
        return this.configuration.getNodes();
    }

    public void setNodes(String nodes) {
        this.configuration.setNodes(nodes);
    }

    public void setNodes(List<String> nodes) {
        this.configuration.setNodes(nodes);
    }

    public String getNamespace() {
        return this.configuration.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.configuration.setNamespace(namespace);
    }

    public long getReconnectBaseSleepTime() {
        return this.configuration.getReconnectBaseSleepTime();
    }

    public void setReconnectBaseSleepTime(long reconnectBaseSleepTime) {
        this.configuration.setReconnectBaseSleepTime(reconnectBaseSleepTime);
    }

    public void setReconnectBaseSleepTime(long reconnectBaseSleepTime, TimeUnit reconnectBaseSleepTimeUnit) {
        this.configuration.setReconnectBaseSleepTime(reconnectBaseSleepTime, reconnectBaseSleepTimeUnit);
    }

    public TimeUnit getReconnectBaseSleepTimeUnit() {
        return this.configuration.getReconnectBaseSleepTimeUnit();
    }

    public void setReconnectBaseSleepTimeUnit(TimeUnit reconnectBaseSleepTimeUnit) {
        this.configuration.setReconnectBaseSleepTimeUnit(reconnectBaseSleepTimeUnit);
    }

    public int getReconnectMaxRetries() {
        return this.configuration.getReconnectMaxRetries();
    }

    public void setReconnectMaxRetries(int reconnectMaxRetries) {
        this.configuration.setReconnectMaxRetries(reconnectMaxRetries);
    }

    public long getSessionTimeout() {
        return this.configuration.getSessionTimeout();
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.configuration.setSessionTimeout(sessionTimeout);
    }

    public void setSessionTimeout(long sessionTimeout, TimeUnit sessionTimeoutUnit) {
        this.configuration.setSessionTimeout(sessionTimeout, sessionTimeoutUnit);
    }

    public TimeUnit getSessionTimeoutUnit() {
        return this.configuration.getSessionTimeoutUnit();
    }

    public void setSessionTimeoutUnit(TimeUnit sessionTimeoutUnit) {
        this.configuration.setSessionTimeoutUnit(sessionTimeoutUnit);
    }

    public long getConnectionTimeout() {
        return this.configuration.getConnectionTimeout();
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.configuration.setConnectionTimeout(connectionTimeout);
    }

    public void setConnectionTimeout(long connectionTimeout, TimeUnit connectionTimeotUnit) {
        this.configuration.setConnectionTimeout(connectionTimeout, connectionTimeotUnit);
    }

    public TimeUnit getConnectionTimeoutUnit() {
        return this.configuration.getConnectionTimeoutUnit();
    }

    public void setConnectionTimeoutUnit(TimeUnit connectionTimeotUnit) {
        this.configuration.setConnectionTimeoutUnit(connectionTimeotUnit);
    }

    public List<AuthInfo> getAuthInfoList() {
        return this.configuration.getAuthInfoList();
    }

    public void setAuthInfoList(List<AuthInfo> authInfoList) {
        this.configuration.setAuthInfoList(authInfoList);
    }

    public long getMaxCloseWait() {
        return this.configuration.getMaxCloseWait();
    }

    public void setMaxCloseWait(long maxCloseWait) {
        this.configuration.setMaxCloseWait(maxCloseWait);
    }

    public TimeUnit getMaxCloseWaitUnit() {
        return this.configuration.getMaxCloseWaitUnit();
    }

    public void setMaxCloseWaitUnit(TimeUnit maxCloseWaitUnit) {
        this.configuration.setMaxCloseWaitUnit(maxCloseWaitUnit);
    }

    public RetryPolicy getRetryPolicy() {
        return this.configuration.getRetryPolicy();
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.configuration.setRetryPolicy(retryPolicy);
    }

    public String getBasePath() {
        return this.configuration.getBasePath();
    }

    public void setBasePath(String basePath) {
        this.configuration.setBasePath(basePath);
    }

    protected ZooKeeperClusterView createView(String namespace) throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"Camel Context");
        ObjectHelper.notNull((Object)this.configuration.getBasePath(), (String)"ZooKeeper base path");
        return new ZooKeeperClusterView((CamelClusterService)this, this.configuration, this.getOrCreateCurator(), namespace);
    }

    protected void doStart() throws Exception {
        this.getOrCreateCurator();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.curator != null && this.managedInstance) {
            this.curator.close();
        }
    }

    private CuratorFramework getOrCreateCurator() {
        if (this.curator == null) {
            this.curator = this.configuration.getCuratorFramework();
            if (this.curator == null) {
                this.managedInstance = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Starting ZooKeeper Curator with namespace '{}',  nodes: '{}'", (Object)this.configuration.getNamespace(), (Object)String.join((CharSequence)",", this.configuration.getNodes()));
                }
                this.curator = ZooKeeperCuratorHelper.createCurator(this.configuration);
                this.curator.start();
            } else {
                this.managedInstance = false;
            }
        }
        return this.curator;
    }
}

