/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import java.util.List;
import org.apache.camel.component.zookeeper.operations.FutureEventDrivenOperation;
import org.apache.camel.component.zookeeper.operations.GetChildrenOperation;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ChildrenChangedOperation
extends FutureEventDrivenOperation<List<String>> {
    private boolean getChangedListing;

    public ChildrenChangedOperation(ZooKeeper connection, String znode) {
        this(connection, znode, true);
    }

    public ChildrenChangedOperation(ZooKeeper connection, String znode, boolean getChangedListing) {
        super(connection, znode, Watcher.Event.EventType.NodeChildrenChanged);
        this.getChangedListing = getChangedListing;
    }

    @Override
    protected void installWatch() {
        this.connection.getChildren(this.getNode(), (Watcher)this, (rc, path, ctx, children, stat) -> {}, null);
    }

    @Override
    public OperationResult<List<String>> getResult() {
        return this.getChangedListing ? new GetChildrenOperation(this.connection, this.node).getResult() : null;
    }

    @Override
    public ZooKeeperOperation<?> createCopy() throws Exception {
        ChildrenChangedOperation copy = (ChildrenChangedOperation)super.createCopy();
        copy.getChangedListing = this.getChangedListing;
        return copy;
    }
}

