/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.cloud;

import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorHelper;
import org.apache.camel.component.zookeeper.cloud.ZooKeeperServiceRegistryConfiguration;
import org.apache.camel.impl.cloud.AbstractServiceRegistry;
import org.apache.camel.util.ObjectHelper;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServiceRegistry
extends AbstractServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperServiceRegistry.class);
    private final Set<String> serviceList = ConcurrentHashMap.newKeySet();
    private final boolean managedInstance;
    private ZooKeeperServiceRegistryConfiguration configuration;
    private CuratorFramework curator;
    private ServiceDiscovery<MetaData> serviceDiscovery;

    public ZooKeeperServiceRegistry() {
        this.configuration = new ZooKeeperServiceRegistryConfiguration();
        this.curator = this.configuration.getCuratorFramework();
        this.managedInstance = Objects.isNull(this.curator);
    }

    public ZooKeeperServiceRegistry(ZooKeeperServiceRegistryConfiguration configuration) {
        this.configuration = configuration.copy();
        this.curator = configuration.getCuratorFramework();
        this.managedInstance = Objects.isNull(this.curator);
    }

    public ZooKeeperServiceRegistryConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ZooKeeperServiceRegistryConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public CuratorFramework getCuratorFramework() {
        return this.configuration.getCuratorFramework();
    }

    public void setCuratorFramework(CuratorFramework curatorFramework) {
        this.configuration.setCuratorFramework(curatorFramework);
    }

    public List<String> getNodes() {
        return this.configuration.getNodes();
    }

    public void setNodes(String nodes) {
        this.configuration.setNodes(nodes);
    }

    public void setNodes(List<String> nodes) {
        this.configuration.setNodes(nodes);
    }

    public String getNamespace() {
        return this.configuration.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.configuration.setNamespace(namespace);
    }

    public long getReconnectBaseSleepTime() {
        return this.configuration.getReconnectBaseSleepTime();
    }

    public void setReconnectBaseSleepTime(long reconnectBaseSleepTime) {
        this.configuration.setReconnectBaseSleepTime(reconnectBaseSleepTime);
    }

    public void setReconnectBaseSleepTime(long reconnectBaseSleepTime, TimeUnit reconnectBaseSleepTimeUnit) {
        this.configuration.setReconnectBaseSleepTime(reconnectBaseSleepTime, reconnectBaseSleepTimeUnit);
    }

    public TimeUnit getReconnectBaseSleepTimeUnit() {
        return this.configuration.getReconnectBaseSleepTimeUnit();
    }

    public void setReconnectBaseSleepTimeUnit(TimeUnit reconnectBaseSleepTimeUnit) {
        this.configuration.setReconnectBaseSleepTimeUnit(reconnectBaseSleepTimeUnit);
    }

    public long getReconnectMaxSleepTime() {
        return this.configuration.getReconnectMaxSleepTime();
    }

    public void setReconnectMaxSleepTime(long reconnectMaxSleepTime) {
        this.configuration.setReconnectMaxSleepTime(reconnectMaxSleepTime);
    }

    public void setReconnectMaxSleepTime(long reconnectMaxSleepTime, TimeUnit reconnectBaseSleepTimeUnit) {
        this.configuration.setReconnectMaxSleepTime(reconnectMaxSleepTime, reconnectBaseSleepTimeUnit);
    }

    public TimeUnit getReconnectMaxSleepTimeUnit() {
        return this.configuration.getReconnectMaxSleepTimeUnit();
    }

    public void setReconnectMaxSleepTimeUnit(TimeUnit reconnectMaxSleepTimeUnit) {
        this.configuration.setReconnectMaxSleepTimeUnit(reconnectMaxSleepTimeUnit);
    }

    public int getReconnectMaxRetries() {
        return this.configuration.getReconnectMaxRetries();
    }

    public void setReconnectMaxRetries(int reconnectMaxRetries) {
        this.configuration.setReconnectMaxRetries(reconnectMaxRetries);
    }

    public long getSessionTimeout() {
        return this.configuration.getSessionTimeout();
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.configuration.setSessionTimeout(sessionTimeout);
    }

    public void setSessionTimeout(long sessionTimeout, TimeUnit sessionTimeoutUnit) {
        this.configuration.setSessionTimeout(sessionTimeout, sessionTimeoutUnit);
    }

    public TimeUnit getSessionTimeoutUnit() {
        return this.configuration.getSessionTimeoutUnit();
    }

    public void setSessionTimeoutUnit(TimeUnit sessionTimeoutUnit) {
        this.configuration.setSessionTimeoutUnit(sessionTimeoutUnit);
    }

    public long getConnectionTimeout() {
        return this.configuration.getConnectionTimeout();
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.configuration.setConnectionTimeout(connectionTimeout);
    }

    public void setConnectionTimeout(long connectionTimeout, TimeUnit connectionTimeotUnit) {
        this.configuration.setConnectionTimeout(connectionTimeout, connectionTimeotUnit);
    }

    public TimeUnit getConnectionTimeoutUnit() {
        return this.configuration.getConnectionTimeoutUnit();
    }

    public void setConnectionTimeoutUnit(TimeUnit connectionTimeoutUnit) {
        this.configuration.setConnectionTimeoutUnit(connectionTimeoutUnit);
    }

    public List<AuthInfo> getAuthInfoList() {
        return this.configuration.getAuthInfoList();
    }

    public void setAuthInfoList(List<AuthInfo> authInfoList) {
        this.configuration.setAuthInfoList(authInfoList);
    }

    public long getMaxCloseWait() {
        return this.configuration.getMaxCloseWait();
    }

    public void setMaxCloseWait(long maxCloseWait) {
        this.configuration.setMaxCloseWait(maxCloseWait);
    }

    public TimeUnit getMaxCloseWaitUnit() {
        return this.configuration.getMaxCloseWaitUnit();
    }

    public void setMaxCloseWaitUnit(TimeUnit maxCloseWaitUnit) {
        this.configuration.setMaxCloseWaitUnit(maxCloseWaitUnit);
    }

    public RetryPolicy getRetryPolicy() {
        return this.configuration.getRetryPolicy();
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.configuration.setRetryPolicy(retryPolicy);
    }

    public String getBasePath() {
        return this.configuration.getBasePath();
    }

    public void setBasePath(String basePath) {
        this.configuration.setBasePath(basePath);
    }

    public boolean isDeregisterServicesOnStop() {
        return this.configuration.isDeregisterServicesOnStop();
    }

    public void setDeregisterServicesOnStop(boolean deregisterServicesOnStop) {
        this.configuration.setDeregisterServicesOnStop(deregisterServicesOnStop);
    }

    public boolean isOverrideServiceHost() {
        return this.configuration.isOverrideServiceHost();
    }

    public void setOverrideServiceHost(boolean overrideServiceHost) {
        this.configuration.setOverrideServiceHost(overrideServiceHost);
    }

    public String getServiceHost() {
        return this.configuration.getServiceHost();
    }

    public void setServiceHost(String serviceHost) {
        this.configuration.setServiceHost(serviceHost);
    }

    protected void doStart() throws Exception {
        if (this.curator == null) {
            ObjectHelper.notNull((Object)this.getCamelContext(), (String)"Camel Context");
            ObjectHelper.notNull((Object)this.configuration.getBasePath(), (String)"ZooKeeper base path");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Starting ZooKeeper Curator with namespace '{}', nodes: '{}'", (Object)this.configuration.getNamespace(), (Object)String.join((CharSequence)",", this.configuration.getNodes()));
            }
            this.curator = ZooKeeperCuratorHelper.createCurator(this.configuration);
            this.curator.start();
        }
        if (this.serviceDiscovery == null) {
            ObjectHelper.notNull((Object)this.configuration.getBasePath(), (String)"ZooKeeper base path");
            LOGGER.debug("Starting ZooKeeper ServiceDiscoveryBuilder with base path '{}'", (Object)this.configuration.getBasePath());
            this.serviceDiscovery = ZooKeeperCuratorHelper.createServiceDiscovery(this.configuration, this.curator, MetaData.class);
            this.serviceDiscovery.start();
        }
    }

    protected void doStop() throws Exception {
        if (this.serviceDiscovery != null) {
            try {
                if (this.configuration.isDeregisterServicesOnStop()) {
                    for (String serviceName : this.serviceDiscovery.queryForNames()) {
                        for (ServiceInstance serviceInstance : this.serviceDiscovery.queryForInstances(serviceName)) {
                            if (!this.serviceList.contains(serviceInstance.getId())) continue;
                            this.serviceDiscovery.unregisterService(serviceInstance);
                            this.serviceList.remove(serviceInstance.getId());
                        }
                    }
                }
                this.serviceDiscovery.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error closing Curator ServiceDiscovery", (Throwable)e);
            }
        }
        if (this.curator != null && this.managedInstance) {
            this.curator.close();
        }
    }

    public void register(ServiceDefinition definition) {
        if (definition.getId() == null) {
            throw new IllegalArgumentException("Service ID must be defined (definition=" + definition + ")");
        }
        if (definition.getName() == null) {
            throw new IllegalArgumentException("Service Name must be defined (definition=" + definition + ")");
        }
        try {
            ServiceInstance instance = ServiceInstance.builder().address(this.computeServiceHost(definition)).port(definition.getPort()).name(definition.getName()).id(definition.getId()).payload((Object)new MetaData(definition.getMetadata())).build();
            this.serviceDiscovery.registerService(instance);
            this.serviceList.add(definition.getId());
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public void deregister(ServiceDefinition definition) {
        if (definition.getId() == null) {
            throw new IllegalArgumentException("Service ID must be defined (definition=" + definition + ")");
        }
        if (definition.getName() == null) {
            throw new IllegalArgumentException("Service Name must be defined (definition=" + definition + ")");
        }
        try {
            for (ServiceInstance serviceInstance : this.serviceDiscovery.queryForInstances(definition.getName())) {
                if (!Objects.equals(serviceInstance.getId(), definition.getId())) continue;
                this.serviceDiscovery.unregisterService(serviceInstance);
                this.serviceList.remove(serviceInstance.getId());
            }
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    private String computeServiceHost(ServiceDefinition definition) {
        String host = definition.getHost();
        if (this.configuration.isOverrideServiceHost() && this.configuration.getServiceHost() != null) {
            host = this.configuration.getServiceHost();
        }
        return (String)ObjectHelper.notNull((Object)host, (String)"service host");
    }

    @JsonRootName(value="meta")
    public static final class MetaData
    extends HashMap<String, String> {
        public MetaData() {
        }

        public MetaData(Map<? extends String, ? extends String> meta) {
            super(meta);
        }
    }
}

