/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster.group;

import java.util.concurrent.ThreadFactory;
import org.apache.camel.component.zookeepermaster.group.Group;
import org.apache.camel.component.zookeepermaster.group.ManagedGroupFactory;
import org.apache.camel.component.zookeepermaster.group.NodeState;
import org.apache.camel.component.zookeepermaster.group.internal.ZooKeeperGroup;
import org.apache.camel.component.zookeepermaster.group.internal.ZooKeeperMultiGroup;
import org.apache.curator.framework.CuratorFramework;

public class DefaultManagedGroupFactory
implements ManagedGroupFactory {
    private final CuratorFramework curator;
    private final boolean shouldClose;

    public DefaultManagedGroupFactory(CuratorFramework curator, boolean shouldClose) {
        this.curator = curator;
        this.shouldClose = shouldClose;
    }

    @Override
    public CuratorFramework getCurator() {
        return this.curator;
    }

    @Override
    public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz) {
        return new ZooKeeperGroup<T>(this.curator, path, clazz);
    }

    @Override
    public <T extends NodeState> Group<T> createGroup(String path, Class<T> clazz, ThreadFactory threadFactory) {
        return new ZooKeeperGroup<T>(this.curator, path, clazz, threadFactory);
    }

    @Override
    public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz) {
        return new ZooKeeperMultiGroup<T>(this.curator, path, clazz);
    }

    @Override
    public <T extends NodeState> Group<T> createMultiGroup(String path, Class<T> clazz, ThreadFactory threadFactory) {
        return new ZooKeeperMultiGroup<T>(this.curator, path, clazz, threadFactory);
    }

    @Override
    public void close() {
        if (this.shouldClose) {
            this.curator.close();
        }
    }
}

