/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.zipfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.util.IOHelper;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipIterator
implements Iterator<Message>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ZipIterator.class);
    private final Exchange exchange;
    private boolean allowEmptyDirectory;
    private volatile ZipArchiveInputStream zipInputStream;
    private volatile ZipArchiveEntry currentEntry;
    private volatile Message parent;
    private volatile boolean first;

    public ZipIterator(Exchange exchange, InputStream inputStream) {
        this.exchange = exchange;
        this.allowEmptyDirectory = false;
        Objects.requireNonNull(inputStream);
        if (inputStream instanceof ZipArchiveInputStream) {
            this.zipInputStream = (ZipArchiveInputStream)inputStream;
        } else {
            try {
                ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream("zip", (InputStream)new BufferedInputStream(inputStream));
                this.zipInputStream = (ZipArchiveInputStream)input;
            }
            catch (ArchiveException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        this.parent = null;
        this.first = true;
    }

    @Override
    public boolean hasNext() {
        boolean answer = this.doHasNext();
        LOG.trace("hasNext: {}", (Object)answer);
        return answer;
    }

    protected boolean doHasNext() {
        try {
            boolean availableDataInCurrentEntry;
            if (this.zipInputStream == null) {
                return false;
            }
            boolean bl = availableDataInCurrentEntry = this.currentEntry != null;
            if (!availableDataInCurrentEntry) {
                this.parent = this.getNextElement();
                if (this.parent == null) {
                    this.zipInputStream.close();
                    availableDataInCurrentEntry = false;
                } else {
                    availableDataInCurrentEntry = true;
                }
                if (this.first && this.parent == null) {
                    throw new IllegalStateException("Unable to unzip the file, it may be corrupted.");
                }
            }
            return availableDataInCurrentEntry;
        }
        catch (IOException exception) {
            throw new RuntimeCamelException((Throwable)exception);
        }
    }

    @Override
    public Message next() {
        Message answer = this.doNext();
        LOG.trace("next: {}", (Object)answer);
        return answer;
    }

    protected Message doNext() {
        if (this.parent == null) {
            this.parent = this.getNextElement();
        }
        Message answer = this.parent;
        this.parent = null;
        this.currentEntry = null;
        if (this.first && answer == null) {
            throw new IllegalStateException("Unable to unzip the file, it may be corrupted.");
        }
        this.first = false;
        this.checkNullAnswer(answer);
        return answer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Message getNextElement() {
        if (this.zipInputStream == null) {
            return null;
        }
        try {
            this.currentEntry = this.getNextEntry();
            if (this.currentEntry != null) {
                LOG.debug("read zipEntry {}", (Object)this.currentEntry.getName());
                DefaultMessage answer = new DefaultMessage(this.exchange.getContext());
                answer.getHeaders().putAll(this.exchange.getIn().getHeaders());
                answer.setHeader("zipFileName", (Object)this.currentEntry.getName());
                answer.setHeader("CamelFileName", (Object)this.currentEntry.getName());
                if (this.currentEntry.isDirectory()) {
                    if (!this.allowEmptyDirectory) return this.getNextElement();
                    answer.setBody((Object)new ByteArrayInputStream(new byte[0]));
                    return answer;
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOHelper.copy((InputStream)this.zipInputStream, (OutputStream)baos);
                    byte[] data = baos.toByteArray();
                    answer.setBody((Object)new ByteArrayInputStream(data));
                }
                return answer;
            }
            LOG.trace("close zipInputStream");
            return null;
        }
        catch (IOException exception) {
            throw new RuntimeCamelException((Throwable)exception);
        }
    }

    public void checkNullAnswer(Message answer) {
        if (answer == null && this.zipInputStream != null) {
            IOHelper.close((Closeable)this.zipInputStream);
            this.zipInputStream = null;
        }
    }

    private ZipArchiveEntry getNextEntry() throws IOException {
        ZipArchiveEntry entry;
        while ((entry = this.zipInputStream.getNextEntry()) != null) {
            if (!entry.isDirectory()) {
                return entry;
            }
            if (!this.allowEmptyDirectory) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        IOHelper.close((Closeable)this.zipInputStream);
        this.zipInputStream = null;
        this.currentEntry = null;
    }

    public boolean isSupportIteratorForEmptyDirectory() {
        return this.allowEmptyDirectory;
    }

    public void setAllowEmptyDirectory(boolean allowEmptyDirectory) {
        this.allowEmptyDirectory = allowEmptyDirectory;
    }
}

