/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.zendesk.ZendeskConfiguration;
import org.apache.camel.component.zendesk.ZendeskEndpoint;
import org.apache.camel.component.zendesk.internal.ZendeskApiMethod;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class ZendeskEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ZendeskEndpoint target = (ZendeskEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold((Integer)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold((Integer)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier((Integer)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                target.setDelay((Long)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)ZendeskEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)ZendeskEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "greedy": {
                target.setGreedy((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "inbody": 
            case "inBody": {
                target.setInBody((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay((Long)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "oauthtoken": 
            case "oauthToken": {
                ((ZendeskConfiguration)target.getConfiguration()).setOauthToken((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "password": {
                ((ZendeskConfiguration)target.getConfiguration()).setPassword((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy((PollingConsumerPollStrategy)ZendeskEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount((Long)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel((LoggingLevel)ZendeskEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService((ScheduledExecutorService)ZendeskEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(ZendeskEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties((Map)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "serverurl": 
            case "serverUrl": {
                ((ZendeskConfiguration)target.getConfiguration()).setServerUrl((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit((TimeUnit)((Object)ZendeskEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "token": {
                ((ZendeskConfiguration)target.getConfiguration()).setToken((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "username": {
                ((ZendeskConfiguration)target.getConfiguration()).setUsername((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return Integer.TYPE;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return Integer.TYPE;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return Integer.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "delay": {
                return Long.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "greedy": {
                return Boolean.TYPE;
            }
            case "inbody": 
            case "inBody": {
                return String.class;
            }
            case "initialdelay": 
            case "initialDelay": {
                return Long.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "oauthtoken": 
            case "oauthToken": {
                return String.class;
            }
            case "password": {
                return String.class;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return PollingConsumerPollStrategy.class;
            }
            case "repeatcount": 
            case "repeatCount": {
                return Long.TYPE;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return LoggingLevel.class;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return ScheduledExecutorService.class;
            }
            case "scheduler": {
                return Object.class;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Map.class;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return Boolean.TYPE;
            }
            case "serverurl": 
            case "serverUrl": {
                return String.class;
            }
            case "startscheduler": 
            case "startScheduler": {
                return Boolean.TYPE;
            }
            case "timeunit": 
            case "timeUnit": {
                return TimeUnit.class;
            }
            case "token": {
                return String.class;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return Boolean.TYPE;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ZendeskEndpoint target = (ZendeskEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "delay": {
                return target.getDelay();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "inbody": 
            case "inBody": {
                return target.getInBody();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "oauthtoken": 
            case "oauthToken": {
                return ((ZendeskConfiguration)target.getConfiguration()).getOauthToken();
            }
            case "password": {
                return ((ZendeskConfiguration)target.getConfiguration()).getPassword();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "serverurl": 
            case "serverUrl": {
                return ((ZendeskConfiguration)target.getConfiguration()).getServerUrl();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "token": {
                return ((ZendeskConfiguration)target.getConfiguration()).getToken();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
            case "username": {
                return ((ZendeskConfiguration)target.getConfiguration()).getUsername();
            }
        }
        return null;
    }

    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Object.class;
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("MethodName", ZendeskApiMethod.class);
        map.put("InBody", String.class);
        map.put("ServerUrl", String.class);
        map.put("SendEmptyMessageWhenIdle", Boolean.TYPE);
        map.put("BridgeErrorHandler", Boolean.TYPE);
        map.put("ExceptionHandler", ExceptionHandler.class);
        map.put("ExchangePattern", ExchangePattern.class);
        map.put("PollStrategy", PollingConsumerPollStrategy.class);
        map.put("LazyStartProducer", Boolean.TYPE);
        map.put("BackoffErrorThreshold", Integer.TYPE);
        map.put("BackoffIdleThreshold", Integer.TYPE);
        map.put("BackoffMultiplier", Integer.TYPE);
        map.put("Delay", Long.TYPE);
        map.put("Greedy", Boolean.TYPE);
        map.put("InitialDelay", Long.TYPE);
        map.put("RepeatCount", Long.TYPE);
        map.put("RunLoggingLevel", LoggingLevel.class);
        map.put("ScheduledExecutorService", ScheduledExecutorService.class);
        map.put("Scheduler", Object.class);
        map.put("SchedulerProperties", Map.class);
        map.put("StartScheduler", Boolean.TYPE);
        map.put("TimeUnit", TimeUnit.class);
        map.put("UseFixedDelay", Boolean.TYPE);
        map.put("OauthToken", String.class);
        map.put("Password", String.class);
        map.put("Token", String.class);
        map.put("Username", String.class);
        ALL_OPTIONS = map;
    }
}

