/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zeebe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorker;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.zeebe.ZeebeEndpoint;
import org.apache.camel.component.zeebe.internal.OperationName;
import org.apache.camel.component.zeebe.model.JobWorkerMessage;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeebeConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeConsumer.class);
    private final ZeebeEndpoint endpoint;
    private JobWorker jobWorker;
    private ObjectMapper objectMapper = new ObjectMapper();

    public ZeebeConsumer(ZeebeEndpoint endpoint, Processor processor) throws CamelException {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        OperationName operationName = this.getEndpoint().getOperationName();
        switch (operationName) {
            case REGISTER_JOB_WORKER: {
                ObjectHelper.notNull((Object)this.getEndpoint().getJobKey(), (String)"jobKey");
                this.jobWorker = this.getEndpoint().getZeebeService().registerJobHandler(new ConsumerJobHandler(), this.getEndpoint().getJobKey(), this.getEndpoint().getTimeout());
                break;
            }
            default: {
                throw new CamelException(String.format("Invalid Operation for Consumer %s", operationName.value()));
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.jobWorker != null && this.jobWorker.isOpen()) {
            this.jobWorker.close();
        }
    }

    public ZeebeEndpoint getEndpoint() {
        return this.endpoint;
    }

    private class ConsumerJobHandler
    implements JobHandler {
        private ConsumerJobHandler() {
        }

        public void handle(JobClient client, ActivatedJob job) throws Exception {
            Exchange exchange = ZeebeConsumer.this.createExchange(true);
            JobWorkerMessage message = new JobWorkerMessage();
            message.setKey(job.getKey());
            message.setType(job.getType());
            message.setCustomHeaders(job.getCustomHeaders());
            message.setProcessInstanceKey(job.getProcessInstanceKey());
            message.setBpmnProcessId(job.getBpmnProcessId());
            message.setProcessDefinitionVersion(job.getProcessDefinitionVersion());
            message.setProcessDefinitionKey(job.getProcessDefinitionKey());
            message.setElementId(job.getElementId());
            message.setElementInstanceKey(job.getElementInstanceKey());
            message.setWorker(job.getWorker());
            message.setRetries(job.getRetries());
            message.setDeadline(job.getDeadline());
            message.setVariables(job.getVariablesAsMap());
            if (LOG.isDebugEnabled()) {
                LOG.debug("New Job Message: {}", (Object)job.toJson());
            }
            if (ZeebeConsumer.this.getEndpoint().isFormatJSON()) {
                try {
                    exchange.getMessage().setBody((Object)ZeebeConsumer.this.objectMapper.writeValueAsString((Object)message));
                    exchange.getMessage().setHeader("CamelZeebeJobKey", (Object)job.getKey());
                }
                catch (JsonProcessingException jsonProcessingException) {
                    throw new IllegalArgumentException("Cannot convert result", jsonProcessingException);
                }
            } else {
                exchange.getMessage().setBody((Object)message);
            }
            AsyncCallback cb = ZeebeConsumer.this.defaultConsumerCallback(exchange, true);
            ZeebeConsumer.this.getAsyncProcessor().process(exchange, cb);
        }
    }
}

