/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.dsl.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.Modifier;
import org.apache.camel.CamelContext;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.maven.dsl.yaml.GenerateYamlSupportMojo;
import org.apache.camel.maven.dsl.yaml.support.Schema;
import org.apache.camel.maven.dsl.yaml.support.TypeSpecHolder;
import org.apache.camel.maven.dsl.yaml.support.YamlProperties;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.Node;

@Mojo(name="generate-yaml-deserializers", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateYamlDeserializersMojo
extends GenerateYamlSupportMojo {
    @Parameter(defaultValue="org.apache.camel.dsl.yaml.deserializers")
    protected String packageName;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;
    private static final CamelCatalog CATALOG = new DefaultCamelCatalog();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Map<String, Schema> schemes = new HashMap<String, Schema>();

    @Override
    protected void generate() throws MojoFailureException {
        try {
            for (String name : CATALOG.findDataFormatNames()) {
                this.loadScheme(this.schemes, CATALOG.dataFormatJSonSchema(name));
            }
            for (String name : CATALOG.findLanguageNames()) {
                this.loadScheme(this.schemes, CATALOG.languageJSonSchema(name));
            }
            for (String name : CATALOG.findOtherNames()) {
                this.loadScheme(this.schemes, CATALOG.otherJSonSchema(name));
            }
            for (String name : CATALOG.findModelNames()) {
                this.loadScheme(this.schemes, CATALOG.modelJSonSchema(name));
            }
            this.write(this.generateExpressionDeserializers());
            this.write(this.generateDeserializers());
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void loadScheme(Map<String, Schema> schemes, String s) throws Exception {
        if (s == null) {
            return;
        }
        Schema descriptor = new Schema(MAPPER.createObjectNode(), MAPPER.createObjectNode());
        Schema schema = (Schema)MAPPER.readerForUpdating((Object)descriptor).readValue(s);
        JsonNode type = schema.meta.at("/javaType");
        if (!type.isMissingNode() && type.isTextual()) {
            schemes.put(type.asText(), schema);
        }
    }

    private void write(TypeSpec ... specs) throws Exception {
        this.write(Arrays.asList(specs));
    }

    private void write(Collection<TypeSpec> specs) throws Exception {
        for (TypeSpec typeSpec : specs) {
            StringWriter sw = new StringWriter();
            JavaFile.builder((String)this.packageName, (TypeSpec)typeSpec).addFileComment("Generated by camel-yaml-dsl-maven-plugin - do NOT edit this file!", new Object[0]).indent("    ").build().writeTo((Appendable)sw);
            Path outputDirectory = this.sourcesOutputDir.toPath();
            if (!this.packageName.isEmpty()) {
                for (String packageComponent : this.packageName.split("\\.")) {
                    outputDirectory = outputDirectory.resolve(packageComponent);
                }
                Files.createDirectories(outputDirectory, new FileAttribute[0]);
            }
            FileUtil.updateFile((Path)outputDirectory.resolve(typeSpec.name + ".java"), (String)sw.toString());
        }
    }

    private TypeSpec generateExpressionDeserializers() {
        TypeSpec.Builder type = TypeSpec.classBuilder((String)"ExpressionDeserializers");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        type.superclass((TypeName)CN_DESERIALIZER_SUPPORT);
        AnnotationSpec.Builder suppress = AnnotationSpec.builder(SuppressWarnings.class);
        suppress.addMember("value", "$L", new Object[]{"\"PMD.UnnecessaryFullyQualifiedName\""});
        type.addAnnotation(suppress.build());
        type.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        type.addMethod(MethodSpec.methodBuilder((String)"constructExpressionType").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(Node.class, "node", new Modifier[0]).returns((TypeName)CN_EXPRESSION_DEFINITION).addCode(CodeBlock.builder().addStatement("$T mn = asMappingNode(node)", new Object[]{CN_MAPPING_NODE}).beginControlFlow("if (mn.getValue().size() != 1)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T nt = mn.getValue().get(0)", new Object[]{CN_NODE_TUPLE}).addStatement("$T dc = getDeserializationContext(node)", new Object[]{CN_DESERIALIZATION_CONTEXT}).addStatement("String key = asText(nt.getKeyNode())", new Object[0]).addStatement("$T val = setDeserializationContext(nt.getValueNode(), dc)", new Object[]{CN_NODE}).addStatement("ExpressionDefinition answer = constructExpressionType(key, val)", new Object[0]).beginControlFlow("if (answer == null)", new Object[0]).addStatement("throw new org.apache.camel.dsl.yaml.common.exception.InvalidExpressionException(node, \"Unknown expression with id: \" + key)", new Object[0]).endControlFlow().addStatement("return answer", new Object[0]).build()).build());
        CodeBlock.Builder cb = CodeBlock.builder();
        cb.beginControlFlow("switch(id)", new Object[0]);
        this.elementsOf(EXPRESSION_DEFINITION_CLASS).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            cb.beginControlFlow("case $S:", new Object[]{e.getKey()});
            cb.addStatement("return asType(node, $L.class)", new Object[]{((ClassInfo)e.getValue()).name().toString()});
            cb.endControlFlow();
        });
        cb.beginControlFlow("case \"expression\":", new Object[0]);
        cb.addStatement("return constructExpressionType(node)", new Object[0]);
        cb.endControlFlow();
        cb.beginControlFlow("case \"expression-type\":", new Object[0]);
        cb.addStatement("return constructExpressionType(node)", new Object[0]);
        cb.endControlFlow();
        cb.beginControlFlow("case \"expressionType\":", new Object[0]);
        cb.addStatement("return constructExpressionType(node)", new Object[0]);
        cb.endControlFlow();
        cb.endControlFlow();
        cb.addStatement("return null", new Object[0]);
        type.addMethod(MethodSpec.methodBuilder((String)"constructExpressionType").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(String.class, "id", new Modifier[0]).addParameter(Node.class, "node", new Modifier[0]).returns((TypeName)CN_EXPRESSION_DEFINITION).addCode(cb.build()).build());
        AnnotationSpec.Builder edAnnotation = AnnotationSpec.builder((ClassName)CN_YAML_TYPE);
        edAnnotation.addMember("types", "org.apache.camel.model.language.ExpressionDefinition.class", new Object[0]);
        edAnnotation.addMember("order", "org.apache.camel.dsl.yaml.common.YamlDeserializerResolver.ORDER_LOWEST - 1", new Object[0]);
        String oneOfGroup = "expression";
        this.elementsOf(EXPRESSION_DEFINITION_CLASS).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> edAnnotation.addMember("properties", "$L", new Object[]{GenerateYamlDeserializersMojo.yamlPropertyWithSubtype((String)e.getKey(), "object", ((ClassInfo)e.getValue()).name().toString(), oneOfGroup)}));
        type.addType(TypeSpec.classBuilder((String)"ExpressionDefinitionDeserializers").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface(ConstructNode.class).addAnnotation(edAnnotation.build()).addMethod(MethodSpec.methodBuilder((String)"construct").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Node.class, "node", new Modifier[0]).returns(Object.class).addStatement("return constructExpressionType(node)", new Object[0]).build()).build());
        AnnotationSpec.Builder esdAnnotation = AnnotationSpec.builder((ClassName)CN_YAML_TYPE);
        esdAnnotation.addMember("types", "org.apache.camel.model.ExpressionSubElementDefinition.class", new Object[0]);
        esdAnnotation.addMember("order", "org.apache.camel.dsl.yaml.common.YamlDeserializerResolver.ORDER_LOWEST - 1", new Object[0]);
        this.elementsOf(EXPRESSION_DEFINITION_CLASS).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> esdAnnotation.addMember("properties", "$L", new Object[]{GenerateYamlDeserializersMojo.yamlPropertyWithSubtype((String)e.getKey(), "object", ((ClassInfo)e.getValue()).name().toString(), oneOfGroup)}));
        type.addType(TypeSpec.classBuilder((String)"ExpressionSubElementDefinitionDeserializers").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface(ConstructNode.class).addAnnotation(esdAnnotation.build()).addMethod(MethodSpec.methodBuilder((String)"construct").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(Node.class, "node", new Modifier[0]).returns(Object.class).addStatement("$T val = constructExpressionType(node)", new Object[]{CN_EXPRESSION_DEFINITION}).addStatement("return new org.apache.camel.model.ExpressionSubElementDefinition(val)", new Object[0]).build()).build());
        return type.build();
    }

    private Collection<TypeSpec> generateDeserializers() {
        TypeSpec.Builder deserializers = TypeSpec.classBuilder((String)"ModelDeserializers");
        deserializers.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        deserializers.superclass((TypeName)CN_DESERIALIZER_SUPPORT);
        AnnotationSpec.Builder suppress = AnnotationSpec.builder(SuppressWarnings.class);
        suppress.addMember("value", "$L", new Object[]{"\"PMD.UnnecessaryFullyQualifiedName\""});
        deserializers.addAnnotation(suppress.build());
        deserializers.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        CodeBlock.Builder constructors = CodeBlock.builder();
        constructors.beginControlFlow("switch(id)", new Object[0]);
        this.all().filter(ci -> !ci.name().equals((Object)EXPRESSION_DEFINITION_CLASS) && !ci.name().equals((Object)EXPRESSION_SUBELEMENT_DEFINITION_CLASS) && !this.implementType((ClassInfo)ci, ERROR_HANDLER_BUILDER_CLASS)).map(this::generateParser).sorted(Comparator.comparing(o -> o.type.name)).forEach(holder -> {
            deserializers.addType(holder.type);
            if (holder.attributes.containsKey("node")) {
                holder.attributes.get("node").forEach(node -> constructors.addStatement("case $S: return new ModelDeserializers.$L()", new Object[]{node, holder.type.name}));
            }
            if (holder.attributes.containsKey("type")) {
                holder.attributes.get("type").forEach(type -> constructors.addStatement("case $S: return new ModelDeserializers.$L()", new Object[]{type, holder.type.name}));
            }
        });
        constructors.endControlFlow();
        constructors.addStatement("return null", new Object[0]);
        TypeSpec.Builder resolver = TypeSpec.classBuilder((String)"ModelDeserializersResolver");
        resolver.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        resolver.addSuperinterface((TypeName)CN_DESERIALIZER_RESOLVER);
        resolver.addMethod(MethodSpec.methodBuilder((String)"getOrder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Integer.TYPE).addStatement("return YamlDeserializerResolver.ORDER_LOWEST - 1", new Object[0]).build());
        resolver.addMethod(MethodSpec.methodBuilder((String)"resolve").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter(String.class, "id", new Modifier[0]).returns(ConstructNode.class).addCode(constructors.build()).build());
        return Arrays.asList(deserializers.build(), resolver.build());
    }

    private TypeSpecHolder generateParser(ClassInfo info) {
        JsonNode yamlTypeDeprecated;
        JsonNode yamlTypeDescription;
        ClassName targetType = ClassName.get((String)info.name().prefix().toString(), (String)info.name().withoutPackagePrefix(), (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(info.simpleName() + "Deserializer"));
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>();
        ArrayList<AnnotationSpec> properties = new ArrayList<AnnotationSpec>();
        AnnotationSpec.Builder yamlTypeAnnotation = AnnotationSpec.builder((ClassName)CN_YAML_TYPE);
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        if (this.extendsType(info, SEND_DEFINITION_CLASS) || this.extendsType(info, TO_DYNAMIC_DEFINITION_CLASS) || this.extendsType(info, POLL_DEFINITION_CLASS)) {
            builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)CN_ENDPOINT_AWARE_DESERIALIZER_BASE, (TypeName[])new TypeName[]{targetType}));
        } else {
            builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)CN_DESERIALIZER_BASE, (TypeName[])new TypeName[]{targetType}));
        }
        TypeSpecHolder.put(attributes, "type", info.name().toString());
        if (info.name().toString().equals("org.apache.camel.model.InterceptDefinition")) {
            builder.addAnnotation(CN_YAML_IN);
        }
        if (info.name().toString().equals("org.apache.camel.model.InterceptFromDefinition")) {
            builder.addAnnotation(CN_YAML_IN);
        }
        if (info.name().toString().equals("org.apache.camel.model.InterceptSendToEndpointDefinition")) {
            builder.addAnnotation(CN_YAML_IN);
        }
        if (info.name().toString().equals("org.apache.camel.model.OnExceptionDefinition")) {
            builder.addAnnotation(CN_YAML_IN);
        }
        if (info.name().toString().equals("org.apache.camel.model.OnCompletionDefinition")) {
            builder.addAnnotation(CN_YAML_IN);
        }
        if (info.name().toString().equals("org.apache.camel.model.rest.RestDefinition")) {
            builder.addAnnotation(CN_YAML_IN);
        }
        if (info.name().toString().equals("org.apache.camel.model.rest.RestConfigurationDefinition")) {
            builder.addAnnotation(CN_YAML_IN);
        }
        AtomicReference modelName = new AtomicReference();
        GenerateYamlDeserializersMojo.annotationValue(info, XML_ROOT_ELEMENT_ANNOTATION_CLASS, "name").map(AnnotationValue::asString).filter(value -> !"##default".equals(value)).ifPresent(value -> {
            if (!Objects.equals(value, StringHelper.camelCaseToDash((String)value))) {
                yamlTypeAnnotation.addMember("nodes", "$S", new Object[]{StringHelper.camelCaseToDash((String)value)});
                TypeSpecHolder.put(attributes, "node", StringHelper.camelCaseToDash((String)value));
            }
            yamlTypeAnnotation.addMember("nodes", "$S", new Object[]{value});
            modelName.set(value);
            TypeSpecHolder.put(attributes, "node", value);
        });
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($L.class)", new Object[]{info.simpleName()}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"newInstance").addAnnotation(AnnotationSpec.builder(Override.class).build()).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)targetType).addCode(CodeBlock.builder().addStatement("return new $L()", new Object[]{info.simpleName()}).build()).build());
        for (MethodInfo ctor : info.constructors()) {
            boolean ref;
            boolean eh = this.implementType(info, ERROR_HANDLER_DEFINITION_CLASS);
            boolean bl = ref = eh && this.implementType(info, REF_ERROR_HANDLER_DEFINITION_CLASS);
            if (eh && !ref) break;
            if (ctor.parameterTypes().size() != 1 || !((Type)ctor.parameterTypes().get(0)).name().equals((Object)STRING_CLASS)) continue;
            if ((ctor.flags() & 1) == 0) break;
            yamlTypeAnnotation.addMember("inline", "true", new Object[0]);
            builder.addMethod(MethodSpec.methodBuilder((String)"newInstance").addAnnotation(AnnotationSpec.builder(Override.class).build()).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, "value", new Modifier[0]).returns((TypeName)targetType).addCode(CodeBlock.builder().addStatement("return new $L(value)", new Object[]{info.simpleName()}).build()).build());
            break;
        }
        boolean caseAdded = false;
        CodeBlock.Builder setProperty = CodeBlock.builder();
        setProperty.addStatement("propertyKey = org.apache.camel.util.StringHelper.dashToCamelCase(propertyKey)", new Object[0]);
        setProperty.beginControlFlow("switch(propertyKey)", new Object[0]);
        Schema descriptor = this.schemes.computeIfAbsent(info.name().toString(), k -> new Schema(MAPPER.createObjectNode(), MAPPER.createObjectNode()));
        for (FieldInfo field : this.fields(info)) {
            if (!this.generateSetValue(descriptor, (String)modelName.get(), setProperty, field, properties)) continue;
            caseAdded = true;
        }
        if (this.implementType(info, ID_AWARE_CLASS)) {
            setProperty.beginControlFlow("case $S:", new Object[]{"id"});
            setProperty.addStatement("String val = asText(node)", new Object[0]);
            setProperty.addStatement("target.setId(val)", new Object[0]);
            setProperty.addStatement("break", new Object[0]);
            setProperty.endControlFlow();
            setProperty.beginControlFlow("case $S:", new Object[]{"description"});
            setProperty.addStatement("String val = asText(node)", new Object[0]);
            setProperty.addStatement("target.setDescription(val)", new Object[0]);
            setProperty.addStatement("break", new Object[0]);
            setProperty.endControlFlow();
            properties.add(YamlProperties.annotation("id", "string").withDescription(descriptor.description("id")).withDisplayName(descriptor.displayName("id")).build());
            properties.add(YamlProperties.annotation("description", "string").withDescription(descriptor.description("description")).withDisplayName(descriptor.displayName("description")).build());
        }
        if (this.shouldHaveSteps(info)) {
            caseAdded = true;
            setProperty.beginControlFlow("case \"steps\":", new Object[0]);
            setProperty.addStatement("setSteps(target, node)", new Object[0]);
            setProperty.addStatement("break", new Object[0]);
            setProperty.endControlFlow();
            properties.add(GenerateYamlDeserializersMojo.yamlProperty("steps", "array:org.apache.camel.model.ProcessorDefinition"));
        }
        if (this.extendsType(info, SEND_DEFINITION_CLASS) || this.extendsType(info, TO_DYNAMIC_DEFINITION_CLASS) || this.extendsType(info, POLL_DEFINITION_CLASS)) {
            setProperty.beginControlFlow("default:", new Object[0]);
            setProperty.addStatement("return false", new Object[0]);
            setProperty.endControlFlow();
            properties.add(GenerateYamlDeserializersMojo.yamlProperty("parameters", "object"));
            builder.addMethod(MethodSpec.methodBuilder((String)"setEndpointUri").addAnnotation(AnnotationSpec.builder(Override.class).build()).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(CamelContext.class, "camelContext", new Modifier[0]).addParameter(Node.class, "node", new Modifier[0]).addParameter((TypeName)targetType, "target", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ClassName.get(Object.class)}), "parameters", new Modifier[0]).addCode(CodeBlock.builder().addStatement("target.setUri(org.apache.camel.dsl.yaml.common.YamlSupport.createEndpointUri(camelContext, node, target.getUri(), parameters))", new Object[0]).build()).build());
        } else if (this.implementType(info, HAS_EXPRESSION_TYPE_CLASS)) {
            setProperty.beginControlFlow("default:", new Object[0]);
            setProperty.addStatement("$T ed = target.getExpressionType()", new Object[]{CN_EXPRESSION_DEFINITION});
            setProperty.beginControlFlow("if (ed != null)", new Object[0]);
            setProperty.addStatement("throw new org.apache.camel.dsl.yaml.common.exception.DuplicateFieldException(node, propertyName, \"as an expression\")", new Object[0]);
            setProperty.endControlFlow();
            setProperty.addStatement("ed = ExpressionDeserializers.constructExpressionType(propertyKey, node)", new Object[0]);
            setProperty.beginControlFlow("if (ed != null)", new Object[0]);
            setProperty.addStatement("target.setExpressionType(ed)", new Object[0]);
            setProperty.nextControlFlow("else", new Object[0]);
            setProperty.addStatement("return false", new Object[0]);
            setProperty.endControlFlow();
            setProperty.endControlFlow();
            if (!this.extendsType(info, EXPRESSION_DEFINITION_CLASS)) {
                properties.add(GenerateYamlDeserializersMojo.yamlProperty("__extends", "object:org.apache.camel.model.language.ExpressionDefinition", "expression"));
            }
        } else {
            setProperty.beginControlFlow("default:", new Object[0]);
            setProperty.addStatement("return false", new Object[0]);
            setProperty.endControlFlow();
        }
        setProperty.endControlFlow();
        if (caseAdded) {
            setProperty.addStatement("return true", new Object[0]);
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"setProperty").addAnnotation(AnnotationSpec.builder(Override.class).build()).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)targetType, "target", new Modifier[0]).addParameter(String.class, "propertyKey", new Modifier[0]).addParameter(String.class, "propertyName", new Modifier[0]).addParameter(Node.class, "node", new Modifier[0]).returns(Boolean.TYPE).addCode(setProperty.build()).build());
        yamlTypeAnnotation.addMember("types", "$L.class", new Object[]{info.name().toString()});
        yamlTypeAnnotation.addMember("order", "org.apache.camel.dsl.yaml.common.YamlDeserializerResolver.ORDER_LOWEST - 1", new Object[]{info.name().toString()});
        JsonNode yamlTypeDisplayName = descriptor.meta.at("/title");
        if (!yamlTypeDisplayName.isMissingNode() && yamlTypeDisplayName.isTextual()) {
            yamlTypeAnnotation.addMember("displayName", "$S", new Object[]{yamlTypeDisplayName.textValue()});
        }
        if (!(yamlTypeDescription = descriptor.meta.at("/description")).isMissingNode() && yamlTypeDescription.isTextual()) {
            yamlTypeAnnotation.addMember("description", "$S", new Object[]{yamlTypeDescription.textValue()});
        }
        if (!(yamlTypeDeprecated = descriptor.meta.at("/deprecated")).isMissingNode() && yamlTypeDeprecated.isBoolean()) {
            yamlTypeAnnotation.addMember("deprecated", "$L", new Object[]{yamlTypeDeprecated.booleanValue()});
        }
        properties.stream().sorted(Comparator.comparing(a -> ((List)a.members.get("name")).toString())).forEach(spec -> yamlTypeAnnotation.addMember("properties", "$L", new Object[]{spec}));
        builder.addAnnotation(yamlTypeAnnotation.build());
        return new TypeSpecHolder(builder.build(), attributes);
    }

    private boolean expressionRequired(String modelName) {
        return !"method".equals(modelName) && !"tokenize".equals(modelName);
    }

    private boolean generateSetValue(Schema descriptor, String modelName, CodeBlock.Builder cb, FieldInfo field, Collection<AnnotationSpec> annotations) {
        ParameterizedType parameterized;
        Type parameterized2;
        ClassInfo refType;
        if (GenerateYamlDeserializersMojo.hasAnnotation(field, XML_TRANSIENT_CLASS) && !GenerateYamlDeserializersMojo.hasAnnotation(field, DSL_PROPERTY_ANNOTATION)) {
            return false;
        }
        if (GenerateYamlDeserializersMojo.hasAnnotation(field, XML_ELEMENTS_ANNOTATION_CLASS)) {
            AnnotationInstance[] elements = field.annotation(XML_ELEMENTS_ANNOTATION_CLASS).value().asNestedArray();
            if (elements.length > 1) {
                cb.beginControlFlow("case $S:", new Object[]{field.name()});
                cb.addStatement("$T val = asMappingNode(node)", new Object[]{CN_MAPPING_NODE});
                cb.addStatement("setProperties(target, val)", new Object[0]);
                cb.addStatement("break", new Object[0]);
                cb.endControlFlow();
            }
            if (field.type().name().equals((Object)LIST_CLASS)) {
                Type parameterized3 = (Type)field.type().asParameterizedType().arguments().get(0);
                for (AnnotationInstance element : elements) {
                    AnnotationValue name = element.value("name");
                    AnnotationValue type = element.value("type");
                    if (name == null || type == null) continue;
                    String fieldName = name.asString();
                    String paramType = parameterized3.name().toString();
                    cb.beginControlFlow("case $S:", new Object[]{fieldName});
                    cb.addStatement("$L val = asType(node, $L.class)", new Object[]{type.asString(), type.asString()});
                    cb.addStatement("java.util.List<$L> existing = target.get$L()", new Object[]{paramType, StringHelper.capitalize((String)field.name())});
                    cb.beginControlFlow("if (existing == null)", new Object[0]);
                    cb.addStatement("existing = new java.util.ArrayList<>()", new Object[0]);
                    cb.endControlFlow();
                    cb.addStatement("existing.add(val)", new Object[0]);
                    cb.addStatement("target.set$L(existing)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    cb.endControlFlow();
                    annotations.add(YamlProperties.annotation(fieldName, "object").withSubType(type.asString()).withRequired(this.isRequired(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                }
            } else {
                for (AnnotationInstance element : elements) {
                    AnnotationValue name = element.value("name");
                    AnnotationValue type = element.value("type");
                    if (name == null || type == null) continue;
                    String fieldName = name.asString();
                    cb.beginControlFlow("case $S:", new Object[]{fieldName});
                    cb.addStatement("$L val = asType(node, $L.class)", new Object[]{type.asString(), type.asString()});
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    cb.endControlFlow();
                    annotations.add(YamlProperties.annotation(fieldName, "object").withSubType(type.asString()).withRequired(this.isRequired(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).withOneOf(field.name()).build());
                }
            }
            return true;
        }
        if (GenerateYamlDeserializersMojo.hasAnnotation(field, XML_ELEMENT_REF_ANNOTATION_CLASS) && field.type().name().equals((Object)LIST_CLASS) && this.extendsType(refType = this.view.getClassByName((parameterized2 = (Type)field.type().asParameterizedType().arguments().get(0)).name()), VERB_DEFINITION_CLASS)) {
            this.implementsOrExtends(parameterized2).forEach(ci -> {
                Optional<String> name = GenerateYamlDeserializersMojo.annotationValue(ci, XML_ROOT_ELEMENT_ANNOTATION_CLASS, "name").map(AnnotationValue::asString).filter(value -> !"##default".equals(value));
                if (!name.isPresent()) {
                    return;
                }
                String fieldName = name.get();
                String fieldType = ci.name().toString();
                cb.beginControlFlow("case $S:", new Object[]{fieldName});
                cb.addStatement("java.util.List<$L> existing = target.get$L()", new Object[]{refType.name().toString(), StringHelper.capitalize((String)field.name())});
                cb.beginControlFlow("if (existing == null)", new Object[0]);
                cb.addStatement("existing = new java.util.ArrayList<>()", new Object[0]);
                cb.endControlFlow();
                cb.addStatement("java.util.List val = asFlatList(node, $L.class)", new Object[]{fieldType});
                cb.addStatement("existing.addAll(val)", new Object[0]);
                cb.addStatement("target.set$L(existing)", new Object[]{StringHelper.capitalize((String)field.name())});
                cb.addStatement("break", new Object[0]);
                cb.endControlFlow();
                annotations.add(YamlProperties.annotation(fieldName, "array").withSubType(fieldType).withRequired(this.isRequired(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
            });
            return true;
        }
        if (!(GenerateYamlDeserializersMojo.hasAnnotation(field, XML_ATTRIBUTE_ANNOTATION_CLASS) || GenerateYamlDeserializersMojo.hasAnnotation(field, XML_VALUE_ANNOTATION_CLASS) || GenerateYamlDeserializersMojo.hasAnnotation(field, XML_ELEMENT_ANNOTATION_CLASS) || GenerateYamlDeserializersMojo.hasAnnotation(field, XML_ELEMENT_REF_ANNOTATION_CLASS) || GenerateYamlDeserializersMojo.hasAnnotation(field, XML_TRANSIENT_CLASS))) {
            return false;
        }
        String fieldName = this.fieldName(field);
        if (field.type().kind() == Type.Kind.PARAMETERIZED_TYPE && !(parameterized = field.type().asParameterizedType()).name().equals((Object)CLASS_CLASS) && parameterized.arguments().size() == 1) {
            Type parametrizedType = (Type)parameterized.arguments().get(0);
            if (parametrizedType.name().equals((Object)PROCESSOR_DEFINITION_CLASS)) {
                return false;
            }
            switch (parameterized.name().toString()) {
                case "java.util.List": {
                    if (parametrizedType.name().equals((Object)STRING_CLASS)) {
                        cb.beginControlFlow("case $S:", new Object[]{fieldName});
                        cb.addStatement("java.util.List<String> val = asStringList(node)", new Object[0]);
                        cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                        cb.addStatement("break", new Object[0]);
                        cb.endControlFlow();
                        annotations.add(YamlProperties.annotation(fieldName, "array").withSubType("string").withRequired(this.isRequired(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    } else {
                        ClassInfo ci2 = this.view.getClassByName(parametrizedType.name());
                        String name = this.fieldName(ci2, field);
                        cb.beginControlFlow("case $S:", new Object[]{name});
                        cb.addStatement("java.util.List<$L> val = asFlatList(node, $L.class)", new Object[]{parametrizedType.name().toString(), parametrizedType.name().toString()});
                        cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                        cb.addStatement("break", new Object[0]);
                        cb.endControlFlow();
                        annotations.add(YamlProperties.annotation(name, "array").withSubType(parametrizedType.name().toString()).withRequired(this.isRequired(field)).withDescription(descriptor.description(name)).withDisplayName(descriptor.displayName(name)).withDefaultValue(descriptor.defaultValue(name)).withIsSecret(descriptor.defaultValue(name)).build());
                    }
                    return true;
                }
                case "java.util.Set": {
                    if (parametrizedType.name().equals((Object)STRING_CLASS)) {
                        cb.beginControlFlow("case $S:", new Object[]{fieldName});
                        cb.addStatement("java.util.Set<String> val = asStringSet(node)", new Object[0]);
                        cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                        cb.addStatement("break", new Object[0]);
                        cb.endControlFlow();
                        annotations.add(YamlProperties.annotation(fieldName, "array").withSubType("string").withRequired(this.isRequired(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    } else {
                        ClassInfo ci3 = this.view.getClassByName(parametrizedType.name());
                        String name = this.fieldName(ci3, field);
                        cb.beginControlFlow("case $S:", new Object[]{name});
                        cb.addStatement("var val = asFlatSet(node, $L.class)", new Object[]{parametrizedType.name().toString()});
                        cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                        cb.addStatement("break", new Object[0]);
                        cb.endControlFlow();
                        annotations.add(YamlProperties.annotation(name, "array").withSubType(parametrizedType.name().toString()).withRequired(this.isRequired(field)).withDescription(descriptor.description(name)).withDisplayName(descriptor.displayName(name)).withDefaultValue(descriptor.defaultValue(name)).withIsSecret(descriptor.defaultValue(name)).build());
                    }
                    return true;
                }
            }
            throw new UnsupportedOperationException("Unable to handle field: " + field.name() + " with type: " + field.type().name());
        }
        if ("expression".equals(fieldName) && !this.expressionRequired(modelName)) {
            return true;
        }
        if ("enableCORS".equals(fieldName)) {
            cb.beginControlFlow("case $S:", new Object[]{"enableCors"});
        } else {
            cb.beginControlFlow("case $S:", new Object[]{fieldName});
        }
        ClassInfo c = this.view.getClassByName(field.type().name());
        if (GenerateYamlDeserializersMojo.hasAnnotation(field, XML_JAVA_TYPE_ADAPTER_CLASS)) {
            Type type;
            List arguments;
            Optional<AnnotationValue> adapter = GenerateYamlDeserializersMojo.annotationValue(field, XML_JAVA_TYPE_ADAPTER_CLASS, "value");
            if (adapter.isEmpty()) {
                return false;
            }
            ClassInfo adapterClassInfo = this.view.getClassByName(adapter.get().asClass().name());
            if (adapterClassInfo.superClassType().kind() == Type.Kind.PARAMETERIZED_TYPE && (arguments = adapterClassInfo.superClassType().asParameterizedType().arguments()).size() == 2 && (type = (Type)arguments.get(1)).name().toString().equals("java.util.Map")) {
                cb.addStatement("$L val = asMap(node)", new Object[]{field.type().name().toString()});
                cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                cb.addStatement("break", new Object[0]);
                annotations.add(YamlProperties.annotation(fieldName, "object").withRequired(this.isRequired(field)).withDeprecated(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
            }
        } else if (c != null && c.isEnum()) {
            cb.addStatement("target.set$L(asEnum(node, $L.class))", new Object[]{StringHelper.capitalize((String)field.name()), field.type().name().toString()});
            cb.addStatement("break", new Object[0]);
            TreeSet<String> values = new TreeSet<String>();
            List fields = c.fields();
            for (int i = 1; i < fields.size(); ++i) {
                FieldInfo f = (FieldInfo)fields.get(i);
                if (!f.isEnumConstant()) continue;
                values.add(f.name());
            }
            annotations.add(YamlProperties.annotation(fieldName, "enum:" + String.join((CharSequence)",", values)).withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
        } else if (this.isEnum(field)) {
            cb.addStatement("String val = asText(node)", new Object[0]);
            cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
            cb.addStatement("break", new Object[0]);
            annotations.add(YamlProperties.annotation(fieldName, "enum:" + this.getEnums(field)).withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
        } else {
            block28 : switch (field.type().name().toString()) {
                case "[B": {
                    cb.addStatement("byte[] val = asByteArray(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(YamlProperties.annotation(fieldName, "string").withFormat("binary").withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    break;
                }
                case "Z": 
                case "boolean": {
                    cb.addStatement("boolean val = asBoolean(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(YamlProperties.annotation(fieldName, "boolean").withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    break;
                }
                case "I": 
                case "int": {
                    cb.addStatement("int val = asInt(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(YamlProperties.annotation(fieldName, "number").withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    break;
                }
                case "J": 
                case "long": {
                    cb.addStatement("long val = asLong(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(YamlProperties.annotation(fieldName, "number").withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    break;
                }
                case "D": 
                case "double": {
                    cb.addStatement("double val = asDouble(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(YamlProperties.annotation(fieldName, "number").withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    break;
                }
                case "java.lang.String": {
                    String javaType;
                    cb.addStatement("String val = asText(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    switch (javaType = GenerateYamlDeserializersMojo.annotationValue(field, METADATA_ANNOTATION_CLASS, "javaType").map(AnnotationValue::asString).orElse("string")) {
                        case "java.lang.Boolean": {
                            annotations.add(YamlProperties.annotation(fieldName, "boolean").withRequired(this.isRequired(field)).withDeprecated(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                            break block28;
                        }
                        case "java.lang.Integer": 
                        case "java.lang.Short": 
                        case "java.lang.Long": 
                        case "java.lang.Float": 
                        case "java.lang.Double": {
                            annotations.add(YamlProperties.annotation(fieldName, "number").withRequired(this.isRequired(field)).withDeprecated(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                            break block28;
                        }
                    }
                    annotations.add(YamlProperties.annotation(fieldName, "string").withRequired(this.isRequired(field)).withDeprecated(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    break;
                }
                case "java.lang.Class": {
                    cb.addStatement("java.lang.Class<?> val = asClass(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(YamlProperties.annotation(fieldName, "string").withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    break;
                }
                case "[Ljava.lang.Class;": {
                    cb.addStatement("java.lang.Class<?>[] val = asClassArray(node)", new Object[0]);
                    cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                    cb.addStatement("break", new Object[0]);
                    break;
                }
                case "java.lang.Integer": 
                case "java.lang.Short": 
                case "java.lang.Long": 
                case "java.lang.Float": 
                case "java.lang.Double": {
                    cb.addStatement("String val = asText(node)", new Object[0]);
                    cb.addStatement("target.set$L($L.valueOf(val))", new Object[]{StringHelper.capitalize((String)field.name()), field.type().name().toString()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(YamlProperties.annotation(fieldName, "number").withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    break;
                }
                case "java.lang.Boolean": {
                    cb.addStatement("String val = asText(node)", new Object[0]);
                    cb.addStatement("target.set$L($L.valueOf(val))", new Object[]{StringHelper.capitalize((String)field.name()), field.type().name().toString()});
                    cb.addStatement("break", new Object[0]);
                    annotations.add(YamlProperties.annotation(fieldName, "boolean").withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).build());
                    break;
                }
                default: {
                    if (field.type().kind() == Type.Kind.CLASS) {
                        cb.addStatement("$L val = asType(node, $L.class)", new Object[]{field.type().name().toString(), field.type().name().toString()});
                        cb.addStatement("target.set$L(val)", new Object[]{StringHelper.capitalize((String)field.name())});
                        cb.addStatement("break", new Object[0]);
                        annotations.add(YamlProperties.annotation(fieldName, "object").withSubType(field.type().name().toString()).withRequired(this.isRequired(field)).withRequired(this.isDeprecated(field)).withDescription(descriptor.description(fieldName)).withDisplayName(descriptor.displayName(fieldName)).withDefaultValue(descriptor.defaultValue(fieldName)).withIsSecret(descriptor.isSecret(fieldName)).withOneOf("expression".equals(fieldName) ? "expression" : "").build());
                        break;
                    }
                    throw new UnsupportedOperationException("Unable to handle field: " + field.name() + " with type: " + field.type().name());
                }
            }
        }
        cb.endControlFlow();
        return true;
    }

    private boolean shouldHaveSteps(ClassInfo info) {
        if ("ChoiceDefinition".equals(info.simpleName())) {
            return false;
        }
        return this.implementType(info, OUTPUT_NODE_CLASS);
    }
}

