/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.dsl.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.camel.maven.dsl.yaml.GenerateYamlSupportMojo;
import org.apache.camel.maven.dsl.yaml.support.ToolingSupport;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.StringUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

@Mojo(name="generate-yaml-schema", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true, requiresProject=false)
public class GenerateYamlSchemaMojo
extends GenerateYamlSupportMojo {
    @Parameter(required=true)
    private File outputFile;
    @Parameter(defaultValue="true")
    private boolean additionalProperties = true;
    private ObjectNode items;
    private ObjectNode definitions;
    private ObjectNode step;

    @Override
    protected void generate() throws MojoFailureException {
        ObjectMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS})).enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).build();
        ObjectNode root = mapper.createObjectNode();
        root.put("$schema", "http://json-schema.org/draft-04/schema#");
        root.put("type", "array");
        this.items = root.putObject("items");
        this.items.put("maxProperties", 1);
        if (!this.additionalProperties) {
            this.items.put("additionalProperties", false);
        }
        this.definitions = this.items.putObject("definitions");
        this.step = this.definitions.withObject("/org.apache.camel.model.ProcessorDefinition").put("type", "object").put("maxProperties", 1);
        if (!this.additionalProperties) {
            this.step.put("additionalProperties", false);
        }
        TreeMap types = new TreeMap();
        this.annotated(YAML_TYPE_ANNOTATION).sorted(Comparator.comparingInt(GenerateYamlSupportMojo::getYamlTypeOrder)).forEach(ci -> {
            GenerateYamlSchemaMojo.annotationValue(ci, YAML_TYPE_ANNOTATION, "types").map(AnnotationValue::asStringArray).ifPresent(values -> Stream.of(values).forEach(item -> types.putIfAbsent(item, ci)));
            if (!GenerateYamlSchemaMojo.hasAnnotationValue(ci, YAML_TYPE_ANNOTATION, "types")) {
                types.putIfAbsent(ci.name().toString(), ci);
            }
        });
        HashSet<String> inheritedDefinitions = new HashSet<String>();
        HashSet<String> inlineDefinitions = new HashSet<String>();
        for (Map.Entry entry : types.entrySet()) {
            Set nodes = GenerateYamlSchemaMojo.annotationValue((ClassInfo)entry.getValue(), YAML_TYPE_ANNOTATION, "nodes").map(AnnotationValue::asStringArray).stream().flatMap(Stream::of).collect(Collectors.toCollection(TreeSet::new));
            DotName name = DotName.createSimple((String)((String)entry.getKey()));
            ClassInfo info = this.view.getClassByName(name);
            if (this.isBanned(info)) continue;
            if (GenerateYamlSchemaMojo.hasAnnotation((ClassInfo)entry.getValue(), YAML_IN_ANNOTATION)) {
                nodes.forEach(node -> this.items.withObject("/properties").putObject(node).put("$ref", "#/items/definitions/" + (String)entry.getKey()));
            } else if (this.extendsType(info, PROCESSOR_DEFINITION_CLASS)) {
                nodes.forEach(node -> this.step.withObject("/properties").putObject(node).put("$ref", "#/items/definitions/" + (String)entry.getKey()));
            }
            this.generate((String)entry.getKey(), (ClassInfo)entry.getValue(), inheritedDefinitions, inlineDefinitions);
        }
        for (JsonNode definition : this.definitions) {
            this.kebabToCamelCase(definition);
        }
        this.kebabToCamelCase((JsonNode)this.step);
        this.kebabToCamelCase((JsonNode)root.withObject("/items"));
        if (!inheritedDefinitions.isEmpty()) {
            this.postProcessInheritance(inheritedDefinitions, inlineDefinitions);
        }
        try {
            ToolingSupport.mkparents(this.outputFile);
            StringWriter sw = new StringWriter();
            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)sw, (Object)root);
            FileUtil.updateFile((Path)this.outputFile.toPath(), (String)sw.toString());
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private void generate(String type, ClassInfo info, Set<String> inheritedDefinitions, Set<String> inlineDefinitions) {
        ObjectNode definition = this.definitions.withObject("/" + type);
        ArrayList<AnnotationInstance> properties = new ArrayList<AnnotationInstance>();
        GenerateYamlSchemaMojo.annotationValue(info, YAML_TYPE_ANNOTATION, "displayName").map(AnnotationValue::asString).ifPresent(v -> definition.put("title", v));
        GenerateYamlSchemaMojo.annotationValue(info, YAML_TYPE_ANNOTATION, "description").map(AnnotationValue::asString).ifPresent(v -> definition.put("description", v));
        GenerateYamlSchemaMojo.annotationValue(info, YAML_TYPE_ANNOTATION, "deprecated").map(AnnotationValue::asBoolean).ifPresent(v -> {
            if (v.booleanValue()) {
                definition.put("deprecated", true);
            }
        });
        ObjectNode objectDefinition = definition;
        if (GenerateYamlSchemaMojo.annotationValue(info, YAML_TYPE_ANNOTATION, "inline").map(AnnotationValue::asBoolean).orElse(false).booleanValue()) {
            ArrayNode oneOf = definition.withArray("oneOf");
            oneOf.addObject().put("type", "string");
            objectDefinition = oneOf.addObject();
            inlineDefinitions.add(type);
        }
        objectDefinition.put("type", "object");
        if (!this.additionalProperties) {
            objectDefinition.put("additionalProperties", false);
        }
        this.collectYamlProperties(properties, info);
        properties.sort(Comparator.comparing(property -> GenerateYamlSchemaMojo.annotationValue(property, "name").map(AnnotationValue::asString).orElse("")));
        HashMap<String, ObjectNode> oneOfGroups = new HashMap<String, ObjectNode>();
        for (AnnotationInstance property2 : properties) {
            String objectRef;
            boolean isInOneOf;
            String propertyName = GenerateYamlSchemaMojo.annotationValue(property2, "name").map(AnnotationValue::asString).orElse("");
            String propertyType = GenerateYamlSchemaMojo.annotationValue(property2, "type").map(AnnotationValue::asString).orElse("");
            String propertyDescription = GenerateYamlSchemaMojo.annotationValue(property2, "description").map(AnnotationValue::asString).orElse("");
            String propertyDisplayName = GenerateYamlSchemaMojo.annotationValue(property2, "displayName").map(AnnotationValue::asString).orElse("");
            boolean propertyRequired = GenerateYamlSchemaMojo.annotationValue(property2, "required").map(AnnotationValue::asBoolean).orElse(false);
            boolean propertyDeprecated = GenerateYamlSchemaMojo.annotationValue(property2, "deprecated").map(AnnotationValue::asBoolean).orElse(false);
            String propertyDefaultValue = GenerateYamlSchemaMojo.annotationValue(property2, "defaultValue").map(AnnotationValue::asString).orElse("");
            String propertyFormat = GenerateYamlSchemaMojo.annotationValue(property2, "format").map(AnnotationValue::asString).orElse("");
            String propertyOneOf = GenerateYamlSchemaMojo.annotationValue(property2, "oneOf").map(AnnotationValue::asString).orElse("");
            boolean propertyWrapItem = GenerateYamlSchemaMojo.annotationValue(property2, "wrapItem").map(AnnotationValue::asBoolean).orElse(false);
            boolean bl = isInOneOf = !StringUtils.isEmpty((String)propertyOneOf);
            if (isInOneOf && !oneOfGroups.containsKey(propertyOneOf)) {
                ObjectNode oneOfGroup = objectDefinition.withArray("anyOf").addObject();
                oneOfGroups.put(propertyOneOf, oneOfGroup);
            }
            if (propertyName.equals("__extends") && propertyType.startsWith("object:")) {
                objectRef = StringHelper.after((String)propertyType, (String)":");
                if (isInOneOf) {
                    ArrayNode oneOf = ((ObjectNode)oneOfGroups.get(propertyOneOf)).withArray("oneOf");
                    ObjectNode entry = oneOf.addObject();
                    entry.put("$ref", "#/items/definitions/" + objectRef);
                    if (!propertyRequired) {
                        this.makeOptional(oneOf, entry);
                    }
                } else {
                    objectDefinition.put("$ref", "#/items/definitions/" + objectRef);
                }
                inheritedDefinitions.add(objectRef);
                continue;
            }
            if (propertyName.equals("__extends") && propertyType.startsWith("array:")) {
                objectRef = StringHelper.after((String)propertyType, (String)":");
                objectDefinition.put("type", "array").withObject("/items").put("$ref", "#/items/definitions/" + objectRef);
                continue;
            }
            if (propertyName.startsWith("__")) continue;
            boolean skip = false;
            if (propertyName.equals("inheritErrorHandler")) {
                skip = true;
                Optional<AnnotationValue> av = GenerateYamlSchemaMojo.annotationValue(info, YAML_TYPE_ANNOTATION, "nodes");
                if (av.isPresent()) {
                    String[] sn;
                    for (String n : sn = av.get().asStringArray()) {
                        if (!"load-balance".equals(n) && !"loadBalance".equals(n)) continue;
                        skip = false;
                        break;
                    }
                }
            }
            if (skip) continue;
            ObjectNode finalObjectDefinition = objectDefinition;
            if (isInOneOf) {
                ArrayNode oneOf = ((ObjectNode)oneOfGroups.get(propertyOneOf)).withArray("oneOf");
                ObjectNode entry = oneOf.addObject();
                entry.put("type", "object");
                entry.withArray("required").add(propertyName);
                if (!propertyRequired) {
                    this.makeOptional(oneOf, entry);
                }
                finalObjectDefinition = entry;
                propertyRequired = false;
            }
            this.setProperty(finalObjectDefinition, propertyName, propertyType, propertyDescription, propertyDisplayName, propertyDefaultValue, propertyFormat, propertyDeprecated, propertyWrapItem, this.additionalProperties);
            if (!propertyRequired) continue;
            definition.withArray("required").add(propertyName);
        }
    }

    private void kebabToCamelCase(JsonNode node) {
        ArrayNode required;
        ArrayNode composition;
        if (node.has("not")) {
            node = node.withObject("/not");
        }
        if ((composition = this.extractComposition(node)) != null) {
            composition.forEach(this::kebabToCamelCase);
        }
        if (node.has("required") && (required = (ArrayNode)node.withArray("required")) != null) {
            for (int i = 0; i < required.size(); ++i) {
                String name = required.get(i).asText();
                required.set(i, name);
            }
        }
        if (node.has("properties")) {
            ObjectNode props = node.withObject("/properties");
            ArrayNode required2 = null;
            if (node.has("required")) {
                required2 = (ArrayNode)node.withArray("required");
            }
            this.kebabToCamelCaseProperties(props, required2);
        }
    }

    private void kebabToCamelCaseProperties(ObjectNode props, ArrayNode required) {
        LinkedHashMap<String, JsonNode> rebuild = new LinkedHashMap<String, JsonNode>();
        Iterator it = props.fieldNames();
        while (it.hasNext()) {
            String n = (String)it.next();
            String t = StringHelper.dashToCamelCase((String)n);
            JsonNode prop = props.get(n);
            JsonNode subProps = prop.findPath("properties");
            if (!subProps.isMissingNode()) {
                this.kebabToCamelCaseProperties((ObjectNode)subProps, null);
            }
            rebuild.put(t, prop);
            if (required == null) continue;
            for (int i = 0; i < required.size(); ++i) {
                String r = required.get(i).asText();
                if (!r.equals(n)) continue;
                required.set(i, t);
            }
        }
        if (!rebuild.isEmpty()) {
            props.removeAll();
            rebuild.forEach((arg_0, arg_1) -> ((ObjectNode)props).set(arg_0, arg_1));
        }
    }

    private void setProperty(ObjectNode objectDefinition, String propertyName, String propertyType, String propertyDescription, String propertyDisplayName, String propertyDefaultValue, String propertyFormat, boolean deprecated, boolean wrapItem, boolean additionalProperties) {
        ObjectNode current = objectDefinition.withObject("/properties/" + propertyName);
        current.put("type", propertyType);
        if (!Strings.isNullOrEmpty((String)propertyDisplayName)) {
            current.put("title", propertyDisplayName);
        }
        if (!Strings.isNullOrEmpty((String)propertyDescription)) {
            current.put("description", propertyDescription);
        }
        if (deprecated) {
            current.put("deprecated", true);
        }
        if (!Strings.isNullOrEmpty((String)propertyDefaultValue)) {
            current.put("default", propertyDefaultValue);
        }
        if (!Strings.isNullOrEmpty((String)propertyFormat)) {
            current.put("format", propertyFormat);
        }
        if (propertyType.startsWith("object:")) {
            current.remove("type");
            String objectType = StringHelper.after((String)propertyType, (String)":");
            current.put("$ref", "#/items/definitions/" + objectType);
        } else if (propertyType.startsWith("array:")) {
            current.put("type", "array");
            String arrayType = StringHelper.after((String)propertyType, (String)":");
            if (arrayType.contains(".")) {
                if (wrapItem) {
                    ObjectNode itemSchema = current.withObject("/items");
                    if (!additionalProperties) {
                        itemSchema.put("additionalProperties", false);
                    }
                    itemSchema.put("type", "object").withObject("/properties/" + propertyName).put("$ref", "#/items/definitions/" + arrayType);
                } else {
                    current.withObject("/items").put("$ref", "#/items/definitions/" + arrayType);
                }
            } else if (wrapItem) {
                ObjectNode itemSchema = current.withObject("/items");
                if (!additionalProperties) {
                    itemSchema.put("additionalProperties", false);
                }
                itemSchema.put("type", "object").withObject("/properties/" + propertyName).put("type", arrayType);
            } else {
                current.withObject("/items").put("type", arrayType);
            }
        } else if (propertyType.startsWith("enum:")) {
            current.put("type", "string");
            String enumValues = StringHelper.after((String)propertyType, (String)":");
            for (String enumValue : enumValues.split(",")) {
                current.withArray("enum").add(enumValue);
            }
        }
    }

    private void collectYamlProperties(List<AnnotationInstance> annotations, ClassInfo info) {
        if (info == null) {
            return;
        }
        GenerateYamlSchemaMojo.annotationValue(info, YAML_TYPE_ANNOTATION, "properties").map(AnnotationValue::asNestedArray).stream().flatMap(Stream::of).forEach(property -> {
            DotName dn;
            String propertyName = GenerateYamlSchemaMojo.annotationValue(property, "name").map(AnnotationValue::asString).orElse("");
            String propertyType = GenerateYamlSchemaMojo.annotationValue(property, "type").map(AnnotationValue::asString).orElse("");
            if (ObjectHelper.isEmpty((String)propertyName) || ObjectHelper.isEmpty((String)propertyType)) {
                this.getLog().warn((CharSequence)("Missing name or type for property + " + String.valueOf(property) + " on type " + info.name().toString()));
                return;
            }
            if (propertyType.startsWith("object:") && this.isBanned(this.view.getClassByName(dn = DotName.createSimple((String)propertyType.substring(7))))) {
                return;
            }
            if (propertyName.startsWith("__")) {
                annotations.add((AnnotationInstance)property);
            } else {
                boolean matches = annotations.stream().map(p -> GenerateYamlSchemaMojo.annotationValue(p, "name").map(AnnotationValue::asString).orElse("")).anyMatch(propertyName::equals);
                if (matches) {
                    return;
                }
                annotations.add((AnnotationInstance)property);
            }
            DotName superName = info.superName();
            if (superName != null) {
                this.collectYamlProperties(annotations, this.view.getClassByName(superName));
            }
        });
    }

    private void makeOptional(ArrayNode parent, ObjectNode target) {
        ObjectNode negations = StreamSupport.stream(parent.spliterator(), false).map(ObjectNode.class::cast).filter(entry -> entry.has("not")).findAny().orElseGet(() -> ((ArrayNode)parent).addObject());
        negations.withObject("/not");
        if (target.has("required")) {
            this.extractRequiredFromComposition(negations, target);
            ArrayNode required = target.withArray("required");
            negations.withObject("/not").withArray("anyOf").addObject().withArray("required").addAll(required);
        } else if (target.has("$ref")) {
            negations.withObject("/not").withArray("anyOf").addObject().set("$ref", target.get("$ref"));
        }
    }

    private void extractRequiredFromComposition(ObjectNode negations, ObjectNode object) {
        ArrayNode composition = this.extractComposition((JsonNode)object);
        if (composition == null) {
            return;
        }
        composition.forEach(compositionEntry -> {
            if (!compositionEntry.has("$ref")) {
                String parentName = StringHelper.after((String)compositionEntry.get("$ref").asText(), (String)"/definitions/");
                ObjectNode referredObject = this.definitions.withObject("/" + parentName);
                this.extractRequiredFromComposition(negations, referredObject);
                if (referredObject.has("required")) {
                    negations.withObject("/not").withArray("anyOf").addObject().withArray("required").addAll(referredObject.withArray("required"));
                }
                return;
            }
            if (compositionEntry.has("required")) {
                negations.withObject("/not").withArray("anyOf").addObject().withArray("required").addAll((ArrayNode)compositionEntry.withArray("required"));
            }
        });
    }

    private void postProcessInheritance(Set<String> inheritedDefinitions, Set<String> inlineDefinitions) {
        for (String inherited : inheritedDefinitions) {
            ObjectNode node = this.definitions.withObject("/" + inherited);
            node.remove("additionalProperties");
        }
        this.definitions.properties().forEach(entry -> {
            String name = (String)entry.getKey();
            JsonNode temp = (JsonNode)entry.getValue();
            if (inlineDefinitions.contains(name)) {
                temp = temp.withArray("oneOf").get(1);
            }
            if (temp.has("anyOf")) {
                JsonNode definition = temp;
                StreamSupport.stream(temp.withArray("anyOf").spliterator(), false).forEach(group -> this.postProcessComposition(name, definition, (JsonNode)group, inheritedDefinitions));
            } else {
                this.postProcessComposition(name, temp, temp, inheritedDefinitions);
            }
        });
    }

    private ArrayNode extractComposition(JsonNode target) {
        if (target.has("allOf")) {
            return (ArrayNode)target.withArray("allOf");
        }
        if (target.has("oneOf")) {
            return (ArrayNode)target.withArray("oneOf");
        }
        if (target.has("anyOf")) {
            return (ArrayNode)target.withArray("anyOf");
        }
        return null;
    }

    private void postProcessComposition(String name, JsonNode definition, JsonNode inherited, Set<String> inheritedDefinitions) {
        ArrayNode composition = this.extractComposition(inherited);
        if (composition == null) {
            return;
        }
        int indexToRemove = -1;
        for (int i = 0; i < composition.size(); ++i) {
            String parentName;
            JsonNode compositionEntry = composition.get(i);
            if (compositionEntry.has("not")) {
                if (inheritedDefinitions.contains(name)) {
                    indexToRemove = i;
                    continue;
                }
                this.postProcessNot((JsonNode)compositionEntry.withObject("/not"));
                continue;
            }
            if (compositionEntry.has("properties")) {
                compositionEntry.withObject("/properties").properties().stream().filter(prop -> !definition.withObject("/properties").has((String)prop.getKey())).forEach(prop -> definition.withObject("/properties").putObject((String)prop.getKey()));
            }
            this.postProcessComposition(name, definition, compositionEntry, inheritedDefinitions);
            if (!compositionEntry.has("$ref") || !inheritedDefinitions.contains(parentName = StringHelper.after((String)compositionEntry.get("$ref").asText(), (String)"/definitions/"))) continue;
            ObjectNode parent = this.definitions.withObject("/" + parentName);
            this.postProcessComposition(parentName, definition, (JsonNode)parent, inheritedDefinitions);
            parent.withObject("/properties").properties().stream().filter(prop -> !definition.withObject("/properties").has((String)prop.getKey())).forEach(prop -> definition.withObject("/properties").putObject((String)prop.getKey()));
        }
        if (indexToRemove >= 0) {
            composition.remove(indexToRemove);
        }
    }

    private void postProcessNot(JsonNode notEntry) {
        ArrayNode notAnyOf = (ArrayNode)notEntry.withArray("anyOf");
        ArrayList extractedRequired = new ArrayList();
        StreamSupport.stream(notAnyOf.spliterator(), false).filter(n -> n.has("$ref")).forEach(n -> this.postProcessNotRef(extractedRequired, (JsonNode)n));
        ArrayNode processed = ((ObjectNode)notEntry).putArray("anyOf");
        StreamSupport.stream(notAnyOf.spliterator(), false).filter(n -> !n.has("$ref")).forEach(arg_0 -> ((ArrayNode)processed).add(arg_0));
        extractedRequired.forEach(required -> processed.addObject().withArray("required").addAll(required));
    }

    private void postProcessNotRef(List<ArrayNode> extracted, JsonNode objectWithRef) {
        String parentName = StringHelper.after((String)objectWithRef.get("$ref").asText(), (String)"/definitions/");
        ObjectNode referredObject = this.definitions.withObject("/" + parentName);
        this.postProcessNotRefComposition(extracted, referredObject);
    }

    private void postProcessNotRefComposition(List<ArrayNode> extracted, ObjectNode node) {
        if (node.has("$ref")) {
            this.postProcessNotRef(extracted, (JsonNode)node);
            return;
        }
        if (node.has("required")) {
            extracted.add(node.withArray("required"));
            return;
        }
        ArrayNode composition = this.extractComposition((JsonNode)node);
        if (composition != null) {
            StreamSupport.stream(composition.spliterator(), false).map(ObjectNode.class::cast).forEach(entry -> {
                if (entry.has("$ref")) {
                    this.postProcessNotRef(extracted, (JsonNode)entry);
                } else if (entry.has("required")) {
                    extracted.add(entry.withArray("required"));
                } else {
                    this.postProcessNotRefComposition(extracted, (ObjectNode)entry);
                }
            });
        }
    }
}

