/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.dsl.yaml.support;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.apache.maven.project.MavenProject;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public final class IndexerSupport {
    private IndexerSupport() {
    }

    public static ClassLoader getClassLoader(MavenProject project) {
        if (project == null) {
            return IndexerSupport.class.getClassLoader();
        }
        try {
            ArrayList elements = new ArrayList(project.getCompileClasspathElements());
            URL[] urls = new URL[elements.size()];
            for (int i = 0; i < elements.size(); ++i) {
                urls[i] = new File((String)elements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, IndexerSupport.class.getClassLoader());
        }
        catch (Exception e) {
            return IndexerSupport.class.getClassLoader();
        }
    }

    public static IndexView get(MavenProject project) {
        try {
            ClassLoader classLoader = IndexerSupport.getClassLoader(project);
            Enumeration<URL> elements = classLoader.getResources("META-INF/jandex.idx");
            ArrayList<Index> allIndex = new ArrayList<Index>();
            HashSet<URL> locations = new HashSet<URL>();
            while (elements.hasMoreElements()) {
                URL url = elements.nextElement();
                if (!locations.add(url)) continue;
                InputStream is = url.openStream();
                try {
                    allIndex.add(new IndexReader(is).read());
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            return CompositeIndex.create(allIndex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<FieldInfo> fields(IndexView view, ClassInfo type) {
        return IndexerSupport.fields(view, type, fi -> true);
    }

    public static List<FieldInfo> fields(IndexView view, ClassInfo type, Predicate<FieldInfo> filter) {
        ArrayList<FieldInfo> answer = new ArrayList<FieldInfo>();
        ClassInfo current = type;
        while (current != null) {
            for (FieldInfo fieldInfo : current.fields()) {
                if (!filter.test(fieldInfo)) continue;
                answer.add(fieldInfo);
            }
            Type superType = current.superClassType();
            if (superType == null) break;
            current = view.getClassByName(superType.name());
        }
        return answer;
    }

    public static List<MethodInfo> methods(IndexView view, ClassInfo type) {
        return IndexerSupport.methods(view, type, mi -> true);
    }

    public static List<MethodInfo> methods(IndexView view, ClassInfo type, Predicate<MethodInfo> filter) {
        ArrayList<MethodInfo> answer = new ArrayList<MethodInfo>();
        ClassInfo current = type;
        while (current != null) {
            for (MethodInfo methodInfo : current.methods()) {
                if (!filter.test(methodInfo)) continue;
                answer.add(methodInfo);
            }
            Type superType = current.superClassType();
            if (superType == null) break;
            current = view.getClassByName(superType.name());
        }
        return answer;
    }
}

