/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import org.apache.camel.dsl.yaml.common.YamlDeserializerResolver;
import org.apache.camel.dsl.yaml.deserializers.BeansDeserializer;
import org.apache.camel.dsl.yaml.deserializers.DataFormatsDefinitionDeserializer;
import org.apache.camel.dsl.yaml.deserializers.ErrorHandlerDeserializer;
import org.apache.camel.dsl.yaml.deserializers.ExpressionDeserializers;
import org.apache.camel.dsl.yaml.deserializers.FromDefinitionDeserializer;
import org.apache.camel.dsl.yaml.deserializers.KameletDeserializer;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinitionDeserializer;
import org.apache.camel.dsl.yaml.deserializers.ProcessorDefinitionDeserializer;
import org.apache.camel.dsl.yaml.deserializers.RouteConfigurationDefinitionDeserializer;
import org.apache.camel.dsl.yaml.deserializers.RouteDefinitionDeserializer;
import org.apache.camel.dsl.yaml.deserializers.RouteFromDefinitionDeserializer;
import org.apache.camel.dsl.yaml.deserializers.RouteTemplateDefinitionDeserializer;
import org.apache.camel.dsl.yaml.deserializers.TemplatedRouteDefinitionDeserializer;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.ConstructNode;

public class CustomResolver
implements YamlDeserializerResolver {
    public static final Logger LOG = LoggerFactory.getLogger(CustomResolver.class);
    private final BeansDeserializer beansDeserializer;

    public int getOrder() {
        return 0;
    }

    public CustomResolver(BeansDeserializer beansDeserializer) {
        this.beansDeserializer = beansDeserializer;
    }

    public ConstructNode resolve(String id) {
        if (id != null && id.contains("-")) {
            LOG.warn("The kebab-case '{}' is deprecated and it will be removed in the next version. Use the camelCase '{}' instead.", (Object)id, (Object)StringHelper.dashToCamelCase((String)id));
        }
        switch (id = StringHelper.dashToCamelCase((String)id)) {
            case "from": {
                return new RouteFromDefinitionDeserializer();
            }
            case "org.apache.camel.model.FromDefinition": {
                return new FromDefinitionDeserializer();
            }
            case "route": 
            case "org.apache.camel.model.RouteDefinition": {
                return new RouteDefinitionDeserializer();
            }
            case "routeConfiguration": 
            case "org.apache.camel.model.RouteConfigurationDefinition": {
                return new RouteConfigurationDefinitionDeserializer();
            }
            case "routeTemplate": 
            case "org.apache.camel.model.RouteTemplateDefinition": {
                return new RouteTemplateDefinitionDeserializer();
            }
            case "templatedRoute": 
            case "org.apache.camel.model.TemplatedRouteDefinition": {
                return new TemplatedRouteDefinitionDeserializer();
            }
            case "org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition": {
                return new OutputAwareFromDefinitionDeserializer();
            }
            case "expression": 
            case "org.apache.camel.model.language.ExpressionDefinition": {
                return new ExpressionDeserializers.ExpressionDefinitionDeserializers();
            }
            case "org.apache.camel.model.ExpressionSubElementDefinition": {
                return new ExpressionDeserializers.ExpressionSubElementDefinitionDeserializers();
            }
            case "beans": {
                return this.beansDeserializer;
            }
            case "dataFormats": {
                return new DataFormatsDefinitionDeserializer();
            }
            case "org.apache.camel.model.ErrorHandlerDefinition": {
                return new ErrorHandlerDeserializer();
            }
            case "errorHandler": {
                return new ErrorHandlerDeserializer(true);
            }
            case "org.apache.camel.model.ProcessorDefinition": {
                return new ProcessorDefinitionDeserializer();
            }
            case "kamelet": 
            case "org.apache.camel.model.KameletDefinition": {
                return new KameletDeserializer();
            }
        }
        return null;
    }
}

