/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.xstream.AbstractXStreamWrapper;
import org.apache.camel.spi.ClassResolver;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLOutputFactory;

public class JsonDataFormat
extends AbstractXStreamWrapper {
    private final MappedXMLOutputFactory mof;
    private final MappedXMLInputFactory mif;

    public JsonDataFormat() {
        HashMap nstjsons = new HashMap();
        this.mof = new MappedXMLOutputFactory(nstjsons);
        this.mif = new MappedXMLInputFactory(nstjsons);
    }

    @Override
    protected XStream createXStream(ClassResolver resolver) {
        XStream xs = super.createXStream(resolver);
        if (this.getMode() != null) {
            xs.setMode(this.getModeFromString(this.getMode()));
        } else {
            xs.setMode(1001);
        }
        return xs;
    }

    @Override
    protected HierarchicalStreamWriter createHierarchicalStreamWriter(Exchange exchange, Object body, OutputStream stream) throws XMLStreamException {
        return new StaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(stream));
    }

    @Override
    protected HierarchicalStreamReader createHierarchicalStreamReader(Exchange exchange, InputStream stream) throws XMLStreamException {
        return new StaxReader(new QNameMap(), this.mif.createXMLStreamReader(stream));
    }
}

