/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.StaxConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;

public abstract class AbstractXStreamWrapper
implements DataFormat {
    private XStream xstream;
    private HierarchicalStreamDriver xstreamDriver;
    private StaxConverter staxConverter;
    private List<String> converters;
    private Map<String, String> aliases;
    private Map<String, String[]> omitFields;
    private Map<String, String[]> implicitCollections;
    private String mode;

    public AbstractXStreamWrapper() {
    }

    public AbstractXStreamWrapper(XStream xstream) {
        this.xstream = xstream;
    }

    public XStream getXStream(ClassResolver resolver) {
        if (this.xstream == null) {
            this.xstream = this.createXStream(resolver);
        }
        return this.xstream;
    }

    public void setXStream(XStream xstream) {
        this.xstream = xstream;
    }

    protected XStream createXStream(ClassResolver resolver) {
        block19: {
            this.xstream = this.xstreamDriver != null ? new XStream(this.xstreamDriver) : new XStream();
            try {
                if (this.implicitCollections != null) {
                    for (Map.Entry<String, Object> entry : this.implicitCollections.entrySet()) {
                        for (String name : (String[])entry.getValue()) {
                            this.xstream.addImplicitCollection(resolver.resolveMandatoryClass(entry.getKey()), name);
                        }
                    }
                }
                if (this.aliases != null) {
                    for (Map.Entry<String, Object> entry : this.aliases.entrySet()) {
                        this.xstream.alias(entry.getKey(), resolver.resolveMandatoryClass((String)entry.getValue()));
                        this.xstream.processAnnotations(resolver.resolveMandatoryClass((String)entry.getValue()));
                    }
                }
                if (this.omitFields != null) {
                    for (Map.Entry entry : this.omitFields.entrySet()) {
                        for (String name : (String[])entry.getValue()) {
                            this.xstream.omitField(resolver.resolveMandatoryClass((String)entry.getKey()), name);
                        }
                    }
                }
                if (this.converters == null) break block19;
                for (String string : this.converters) {
                    Converter converter;
                    Class converterClass = resolver.resolveMandatoryClass(string, Converter.class);
                    Constructor con = null;
                    try {
                        con = converterClass.getDeclaredConstructor(XStream.class);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (con != null) {
                        converter = (Converter)con.newInstance(this.xstream);
                    } else {
                        converter = (Converter)converterClass.newInstance();
                        try {
                            Method method = converterClass.getMethod("setXStream", XStream.class);
                            if (method != null) {
                                ObjectHelper.invokeMethod((Method)method, (Object)converter, (Object[])new Object[]{this.xstream});
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    this.xstream.registerConverter(converter);
                }
                if (this.mode != null) {
                    this.xstream.setMode(this.getModeFromString(this.mode));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to build XStream instance", e);
            }
        }
        return this.xstream;
    }

    protected int getModeFromString(String modeString) {
        int result;
        if ("NO_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1001;
        } else if ("ID_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1002;
        } else if ("XPATH_RELATIVE_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1003;
        } else if ("XPATH_ABSOLUTE_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1004;
        } else if ("SINGLE_NODE_XPATH_RELATIVE_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1005;
        } else if ("SINGLE_NODE_XPATH_ABSOLUTE_REFERENCES".equalsIgnoreCase(modeString)) {
            result = 1006;
        } else {
            throw new IllegalArgumentException("Unknown mode : " + modeString);
        }
        return result;
    }

    public StaxConverter getStaxConverter() {
        if (this.staxConverter == null) {
            this.staxConverter = new StaxConverter();
        }
        return this.staxConverter;
    }

    public void setStaxConverter(StaxConverter staxConverter) {
        this.staxConverter = staxConverter;
    }

    public List<String> getConverters() {
        return this.converters;
    }

    public void setConverters(List<String> converters) {
        this.converters = converters;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public Map<String, String[]> getImplicitCollections() {
        return this.implicitCollections;
    }

    public void setImplicitCollections(Map<String, String[]> implicitCollections) {
        this.implicitCollections = implicitCollections;
    }

    public Map<String, String[]> getOmitFields() {
        return this.omitFields;
    }

    public void setOmitFields(Map<String, String[]> omitFields) {
        this.omitFields = omitFields;
    }

    public HierarchicalStreamDriver getXstreamDriver() {
        return this.xstreamDriver;
    }

    public void setXstreamDriver(HierarchicalStreamDriver xstreamDriver) {
        this.xstreamDriver = xstreamDriver;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public XStream getXstream() {
        return this.xstream;
    }

    public void setXstream(XStream xstream) {
        this.xstream = xstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        HierarchicalStreamWriter writer = this.createHierarchicalStreamWriter(exchange, body, stream);
        try {
            this.getXStream(exchange.getContext().getClassResolver()).marshal(body, writer);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        HierarchicalStreamReader reader = this.createHierarchicalStreamReader(exchange, stream);
        try {
            Object object = this.getXStream(exchange.getContext().getClassResolver()).unmarshal(reader);
            return object;
        }
        finally {
            reader.close();
        }
    }

    protected abstract HierarchicalStreamWriter createHierarchicalStreamWriter(Exchange var1, Object var2, OutputStream var3) throws XMLStreamException;

    protected abstract HierarchicalStreamReader createHierarchicalStreamReader(Exchange var1, InputStream var2) throws XMLStreamException;
}

