/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt.saxon;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.apache.camel.Exchange;
import org.apache.camel.component.xslt.XmlSourceHandlerFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SaxonXmlSourceHandlerFactoryImpl
extends XmlSourceHandlerFactoryImpl {
    private static final Logger LOG = LoggerFactory.getLogger(SaxonXmlSourceHandlerFactoryImpl.class);
    private boolean useJsonBody = false;
    private Processor saxonProcessor;
    private XPathExecutable saxonJsonToXmlExecutable;
    private DocumentBuilder documentBuilder;

    public boolean isUseJsonBody() {
        return this.useJsonBody;
    }

    public void setUseJsonBody(boolean useJsonBody) {
        this.useJsonBody = useJsonBody;
    }

    protected Source getSource(Exchange exchange, Object body) {
        if (body instanceof Source) {
            return (Source)body;
        }
        if (this.useJsonBody && body != null) {
            try {
                Source xmlSource;
                String jsonString = (String)exchange.getContext().getTypeConverter().convertTo(String.class, body);
                if (jsonString != null && (xmlSource = this.convertJsonToXmlSource(jsonString)) != null) {
                    LOG.debug("Converted JSON input to XML using XSLT3 json-to-xml() function");
                    return xmlSource;
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to convert JSON to XML, falling back to standard processing: {}", (Object)e.getMessage());
            }
        }
        Source source = null;
        if (body != null) {
            source = (Source)exchange.getContext().getTypeConverter().tryConvertTo(StAXSource.class, exchange, body);
        }
        if (source == null) {
            source = super.getSource(exchange, body);
        }
        return source;
    }

    private Source convertJsonToXmlSource(String jsonString) {
        try {
            XdmItem item;
            XPathSelector selector = this.getSaxonJsonToXmlExecutable().load();
            selector.setContextItem((XdmItem)new XdmAtomicValue(jsonString));
            XdmValue result = selector.evaluate();
            if (!result.isEmpty() && (item = result.itemAt(0)) instanceof XdmNode) {
                XdmNode xdmNode = (XdmNode)item;
                Document doc = this.getDocumentBuilder().newDocument();
                DOMDestination domDest = new DOMDestination((Node)doc);
                this.saxonProcessor.writeXdmValue((XdmValue)xdmNode, (Destination)domDest);
                return new DOMSource(doc);
            }
        }
        catch (ParserConfigurationException | SaxonApiException e) {
            LOG.warn("Failed to convert JSON to XML using XSLT3 json-to-xml() function: {}", (Object)e.getMessage());
        }
        return null;
    }

    private synchronized XPathExecutable getSaxonJsonToXmlExecutable() throws SaxonApiException {
        if (this.saxonJsonToXmlExecutable == null) {
            this.saxonProcessor = new Processor(false);
            XPathCompiler xpathCompiler = this.saxonProcessor.newXPathCompiler();
            this.saxonJsonToXmlExecutable = xpathCompiler.compile("json-to-xml(.)");
            LOG.debug("Initialized reusable XPathExecutable for json-to-xml() function");
        }
        return this.saxonJsonToXmlExecutable;
    }

    private synchronized DocumentBuilder getDocumentBuilder() throws SaxonApiException, ParserConfigurationException {
        if (this.documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = factory.newDocumentBuilder();
        }
        return this.documentBuilder;
    }
}

