/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.xmpp.RuntimeXmppException;
import org.apache.camel.component.xmpp.XmppEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class XmppGroupChatProducer
extends DefaultProducer {
    private static final transient Log log = LogFactory.getLog(XmppGroupChatProducer.class);
    private final XmppEndpoint endpoint;
    private final String room;
    private GroupChat chat;

    public XmppGroupChatProducer(XmppEndpoint endpoint, String room) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.room = room;
        if (room == null) {
            throw new IllegalArgumentException("No room property specified");
        }
    }

    public void process(Exchange exchange) {
        Message message = this.chat.createMessage();
        message.setTo(this.room);
        message.setFrom(this.endpoint.getUser());
        this.endpoint.getBinding().populateXmppMessage(message, exchange);
        if (log.isDebugEnabled()) {
            log.debug((Object)(">>>> message: " + message.getBody()));
        }
        try {
            this.chat.sendMessage(message);
        }
        catch (XMPPException e) {
            throw new RuntimeXmppException(e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.chat == null) {
            this.chat = this.endpoint.getConnection().createGroupChat(this.room);
        }
    }

    protected void doStop() throws Exception {
        if (this.chat != null) {
            this.chat.leave();
            this.chat = null;
        }
        super.doStop();
    }

    public GroupChat getChat() {
        return this.chat;
    }

    public void setChat(GroupChat chat) {
        this.chat = chat;
    }

    public String getRoom() {
        return this.room;
    }
}

