/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xmlsecurity;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class XMLSecurityDataFormat
implements DataFormat {
    private String xmlCipherAlgorithm = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    private byte[] passPhrase = "Just another 24 Byte key".getBytes();
    private String secureTag = "";
    private boolean secureTagContents = true;

    public XMLSecurityDataFormat() {
        Init.init();
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, byte[] passPhrase) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setPassPhrase(passPhrase);
    }

    public XMLSecurityDataFormat(String secureTag, boolean secureTagContents, byte[] passPhrase, String xmlCipherAlgorithm) {
        this();
        this.setSecureTag(secureTag);
        this.setSecureTagContents(secureTagContents);
        this.setPassPhrase(passPhrase);
        this.setXmlCipherAlgorithm(xmlCipherAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        Key dataEncryptionkey;
        Key keyEncryptionkey;
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, graph);
        if (is == null) {
            throw new IllegalArgumentException("Cannot get the inputstream for XMLSecurityDataFormat mashalling");
        }
        Document document = (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)is);
        if (this.xmlCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            keyEncryptionkey = this.generateEncryptionKey("DESede");
            dataEncryptionkey = this.generateEncryptionKey("DESede");
        } else {
            keyEncryptionkey = this.generateEncryptionKey("AES");
            dataEncryptionkey = this.generateEncryptionKey("AES");
        }
        XMLCipher keyCipher = XMLCipher.getInstance((String)this.generateXmlCipherAlgorithmKeyWrap());
        keyCipher.init(3, keyEncryptionkey);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)this.xmlCipherAlgorithm);
        xmlCipher.init(1, dataEncryptionkey);
        if (this.secureTag.equalsIgnoreCase("")) {
            this.embedKeyInfoInEncryptedData(document, keyCipher, xmlCipher, dataEncryptionkey);
            document = xmlCipher.doFinal(document, document.getDocumentElement());
        } else {
            Node node;
            NodeIterator iter = XPathAPI.selectNodeIterator((Node)document, (String)this.secureTag);
            while ((node = iter.nextNode()) != null) {
                this.embedKeyInfoInEncryptedData(document, keyCipher, xmlCipher, dataEncryptionkey);
                Document temp = xmlCipher.doFinal(document, (Element)node, this.getSecureTagContents());
                document.importNode(temp.getDocumentElement().cloneNode(true), true);
            }
        }
        DOMSource source = new DOMSource(document);
        try {
            IOHelper.copy((InputStream)IOConverter.toInputStrean((DOMSource)source), (OutputStream)stream);
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        InputStream is = (InputStream)ExchangeHelper.getMandatoryInBody((Exchange)exchange, InputStream.class);
        Key keyEncryptionkey = this.xmlCipherAlgorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") ? this.generateEncryptionKey("DESede") : this.generateEncryptionKey("AES");
        XMLCipher xmlCipher = XMLCipher.getInstance();
        xmlCipher.init(2, null);
        xmlCipher.setKEK(keyEncryptionkey);
        Document encodedDocument = (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)is);
        if (this.secureTag.equalsIgnoreCase("")) {
            encodedDocument = xmlCipher.doFinal(encodedDocument, encodedDocument.getDocumentElement());
        } else {
            Node node;
            NodeIterator iter = XPathAPI.selectNodeIterator((Node)encodedDocument, (String)this.secureTag);
            while ((node = iter.nextNode()) != null) {
                Document temp = xmlCipher.doFinal(encodedDocument, (Element)node, this.getSecureTagContents());
                encodedDocument.importNode(temp.getDocumentElement().cloneNode(true), true);
            }
        }
        DOMSource source = new DOMSource(encodedDocument);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOHelper.copy((InputStream)IOConverter.toInputStrean((DOMSource)source), (OutputStream)bos);
        }
        finally {
            bos.close();
        }
        return bos.toByteArray();
    }

    private Key generateEncryptionKey(String algorithm) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKey secretKey;
        try {
            if (algorithm.equalsIgnoreCase("DESede")) {
                DESedeKeySpec keySpec = new DESedeKeySpec(this.passPhrase);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
                secretKey = keyFactory.generateSecret(keySpec);
            } else {
                secretKey = new SecretKeySpec(this.passPhrase, "AES");
            }
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException("InvalidKeyException due to invalid passPhrase: " + Arrays.toString(this.passPhrase));
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("NoSuchAlgorithmException while using XMLCipher.TRIPLEDES algorithm: DESede");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeySpecException("Invalid Key generated while using passPhrase: " + Arrays.toString(this.passPhrase));
        }
        return secretKey;
    }

    private void embedKeyInfoInEncryptedData(Document document, XMLCipher keyCipher, XMLCipher xmlCipher, Key dataEncryptionkey) throws XMLEncryptionException {
        EncryptedKey encryptedKey = keyCipher.encryptKey(document, dataEncryptionkey);
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.add(encryptedKey);
        EncryptedData encryptedDataElement = xmlCipher.getEncryptedData();
        encryptedDataElement.setKeyInfo(keyInfo);
    }

    private String generateXmlCipherAlgorithmKeyWrap() {
        String algorithmKeyWrap = null;
        if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
        } else if (this.xmlCipherAlgorithm.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            algorithmKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
        }
        return algorithmKeyWrap;
    }

    public String getXmlCipherAlgorithm() {
        return this.xmlCipherAlgorithm;
    }

    public void setXmlCipherAlgorithm(String xmlCipherAlgorithm) {
        this.xmlCipherAlgorithm = xmlCipherAlgorithm;
    }

    public byte[] getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(byte[] passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getSecureTag() {
        return this.secureTag;
    }

    public void setSecureTag(String secureTag) {
        this.secureTag = secureTag;
    }

    public boolean isSecureTagContents() {
        return this.secureTagContents;
    }

    public boolean getSecureTagContents() {
        return this.secureTagContents;
    }

    public void setSecureTagContents(boolean secureTagContents) {
        this.secureTagContents = secureTagContents;
    }
}

