/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.jaxb;

import jakarta.xml.bind.Binder;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.TypeConversionException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationsDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.TemplatedRoutesDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.URISupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JaxbHelper {
    private static final String CAMEL_NS = "http://camel.apache.org/schema/spring";

    private JaxbHelper() {
    }

    public static JAXBContext getJAXBContext(CamelContext context) throws Exception {
        return (JAXBContext)PluginHelper.getModelJAXBContextFactory((CamelContext)context).newJAXBContext();
    }

    public static void extractNamespaces(RouteDefinition route, Map<String, String> namespaces) {
        Collection col = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), ExpressionNode.class);
        for (ExpressionNode en : col) {
            Map map;
            NamespaceAware na = JaxbHelper.getNamespaceAwareFromExpression(en);
            if (na == null || (map = na.getNamespaces()) == null || map.isEmpty()) continue;
            namespaces.putAll(map);
        }
    }

    public static void extractSourceLocations(RouteDefinition route, Map<String, KeyValueHolder<Integer, String>> locations) {
        String id = route.getRouteId();
        String loc = route.getInput().getLocation();
        int line = route.getInput().getLineNumber();
        if (id != null && line != -1) {
            locations.put(id, (KeyValueHolder<Integer, String>)new KeyValueHolder((Object)line, (Object)loc));
        }
        for (OptionalIdentifiedDefinition def : ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), OptionalIdentifiedDefinition.class)) {
            id = def.getId();
            loc = def.getLocation();
            line = def.getLineNumber();
            if (id == null || line == -1) continue;
            locations.put(id, (KeyValueHolder<Integer, String>)new KeyValueHolder((Object)line, (Object)loc));
        }
    }

    public static void resolveEndpointDslUris(RouteDefinition route) {
        FromDefinition from = route.getInput();
        if (from != null && from.getEndpointConsumerBuilder() != null) {
            String uri = from.getEndpointConsumerBuilder().getRawUri();
            from.setUri(uri);
        }
        Collection col = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), SendDefinition.class);
        for (SendDefinition to : col) {
            if (to.getEndpointProducerBuilder() == null) continue;
            String uri = to.getEndpointProducerBuilder().getRawUri();
            to.setUri(uri);
        }
        Collection col2 = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), ToDynamicDefinition.class);
        for (ToDynamicDefinition to : col2) {
            if (to.getEndpointProducerBuilder() == null) continue;
            String uri = to.getEndpointProducerBuilder().getRawUri();
            to.setUri(uri);
        }
    }

    public static NamespaceAware getNamespaceAwareFromExpression(ExpressionNode expressionNode) {
        ExpressionDefinition ed = expressionNode.getExpression();
        NamespaceAware na = null;
        Expression exp = ed.getExpressionValue();
        if (exp instanceof NamespaceAware) {
            NamespaceAware namespaceAware;
            na = namespaceAware = (NamespaceAware)exp;
        } else if (ed instanceof NamespaceAware) {
            NamespaceAware namespaceAware;
            na = namespaceAware = (NamespaceAware)ed;
        }
        return na;
    }

    public static XmlConverter newXmlConverter(CamelContext context) {
        return new XmlConverter();
    }

    public static void extractNamespaces(Document document, Map<String, String> namespaces) {
        NamedNodeMap attributes = document.getDocumentElement().getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            String nsPrefix = item.getNodeName();
            if (!nsPrefix.startsWith("xmlns")) continue;
            String nsValue = item.getNodeValue();
            String[] nsParts = nsPrefix.split(":");
            if (nsParts.length == 1) {
                namespaces.put(nsParts[0], nsValue);
                continue;
            }
            if (nsParts.length == 2) {
                namespaces.put(nsParts[1], nsValue);
                continue;
            }
            namespaces.put(nsPrefix, nsValue);
        }
    }

    public static void extractSourceLocations(Element element, Map<String, KeyValueHolder<Integer, String>> locations) {
        NamedNodeMap attributes = element.getAttributes();
        String id = null;
        Integer sourceLineNumber = null;
        String sourceLocation = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            String name = item.getNodeName();
            if ("id".equals(name)) {
                id = item.getNodeValue();
                continue;
            }
            if ("sourceLineNumber".equals(name)) {
                sourceLineNumber = Integer.parseInt(item.getNodeValue());
                continue;
            }
            if (!"sourceLocation".equals(name)) continue;
            sourceLocation = item.getNodeValue();
        }
        if (id != null && sourceLineNumber != null && sourceLocation != null) {
            locations.put(id, (KeyValueHolder<Integer, String>)new KeyValueHolder(sourceLineNumber, sourceLocation));
        }
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node child = children.item(index);
            if (child.getNodeType() != 1) continue;
            JaxbHelper.extractSourceLocations((Element)child, locations);
        }
    }

    public static void applyNamespaces(RouteDefinition route, Map<String, String> namespaces) {
        Collection col = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), ExpressionNode.class);
        for (ExpressionNode en : col) {
            NamespaceAware na = JaxbHelper.getNamespaceAwareFromExpression(en);
            if (na == null) continue;
            na.setNamespaces(namespaces);
        }
    }

    public static void applyNamespaces(RouteConfigurationDefinition config, Map<String, String> namespaces) {
        ArrayList defs = new ArrayList();
        defs.addAll(config.getIntercepts());
        defs.addAll(config.getInterceptFroms());
        defs.addAll(config.getInterceptSendTos());
        defs.addAll(config.getOnCompletions());
        defs.addAll(config.getOnExceptions());
        for (OutputDefinition def : defs) {
            Collection col = ProcessorDefinitionHelper.filterTypeInOutputs((List)def.getOutputs(), ExpressionNode.class);
            for (ExpressionNode en : col) {
                NamespaceAware na = JaxbHelper.getNamespaceAwareFromExpression(en);
                if (na == null) continue;
                na.setNamespaces(namespaces);
            }
        }
    }

    public static void applySourceLocations(RouteDefinition route, Map<String, KeyValueHolder<Integer, String>> locations) {
        KeyValueHolder<Integer, String> kv = locations.get(route.getRouteId());
        if (kv != null && route.getInput() != null) {
            route.getInput().setLineNumber(((Integer)kv.getKey()).intValue());
            route.getInput().setLocation((String)kv.getValue());
        }
        Collection def = ProcessorDefinitionHelper.filterTypeInOutputs((List)route.getOutputs(), OptionalIdentifiedDefinition.class);
        for (OptionalIdentifiedDefinition out : def) {
            kv = locations.get(out.getId());
            if (kv == null) continue;
            out.setLineNumber(((Integer)kv.getKey()).intValue());
            out.setLocation((String)kv.getValue());
        }
    }

    public static <T extends NamedNode> T modelToXml(CamelContext context, String xml, Class<T> type) throws Exception {
        Document dom;
        JAXBContext jaxbContext = JaxbHelper.getJAXBContext(context);
        XmlConverter xmlConverter = JaxbHelper.newXmlConverter(context);
        try {
            dom = xmlConverter.toDOMDocument(xml, null);
        }
        catch (Exception e) {
            throw new TypeConversionException((Object)xml, Document.class, (Throwable)e);
        }
        if (dom == null) {
            throw new IllegalArgumentException("InputStream and XML is both null");
        }
        HashMap<String, KeyValueHolder<Integer, String>> locations = new HashMap<String, KeyValueHolder<Integer, String>>();
        if (context.isDebugging().booleanValue()) {
            JaxbHelper.extractSourceLocations(dom.getDocumentElement(), locations);
        }
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        JaxbHelper.extractNamespaces(dom, namespaces);
        Binder binder = jaxbContext.createBinder();
        Object result = binder.unmarshal((Object)dom);
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to " + type + " using JAXB");
        }
        if (result instanceof RouteTemplatesDefinition) {
            RouteTemplatesDefinition routeTemplatesDefinition = (RouteTemplatesDefinition)result;
            List templates = routeTemplatesDefinition.getRouteTemplates();
            for (RouteTemplateDefinition template : templates) {
                RouteDefinition route = template.getRoute();
                JaxbHelper.applyNamespaces(route, namespaces);
                if (!locations.isEmpty()) {
                    JaxbHelper.applySourceLocations(route, locations);
                }
                JaxbHelper.resolveEndpointDslUris(route);
            }
        } else if (result instanceof RouteTemplateDefinition) {
            RouteTemplateDefinition template = (RouteTemplateDefinition)result;
            RouteDefinition route = template.getRoute();
            JaxbHelper.applyNamespaces(route, namespaces);
            if (!locations.isEmpty()) {
                JaxbHelper.applySourceLocations(route, locations);
            }
            JaxbHelper.resolveEndpointDslUris(route);
        } else if (result instanceof RoutesDefinition) {
            RoutesDefinition routesDefinition = (RoutesDefinition)result;
            List routes = routesDefinition.getRoutes();
            for (RouteDefinition route : routes) {
                JaxbHelper.applyNamespaces(route, namespaces);
                if (!locations.isEmpty()) {
                    JaxbHelper.applySourceLocations(route, locations);
                }
                JaxbHelper.resolveEndpointDslUris(route);
            }
        } else if (result instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)result;
            JaxbHelper.applyNamespaces(route, namespaces);
            if (!locations.isEmpty()) {
                JaxbHelper.applySourceLocations(route, locations);
            }
            JaxbHelper.resolveEndpointDslUris(route);
        }
        return (T)((NamedNode)type.cast(result));
    }

    public static RoutesDefinition loadRoutesDefinition(CamelContext context, InputStream inputStream) throws Exception {
        RoutesDefinition answer;
        XmlConverter xmlConverter = JaxbHelper.newXmlConverter(context);
        Document dom = xmlConverter.toDOMDocument(inputStream, null);
        JaxbHelper.removeNoiseFromUris(dom.getDocumentElement());
        JAXBContext jaxbContext = JaxbHelper.getJAXBContext(context);
        Map<String, String> namespaces = JaxbHelper.doExtractNamespaces(dom);
        Binder binder = jaxbContext.createBinder();
        Object result = binder.unmarshal((Object)dom);
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to RoutesDefinition using JAXB");
        }
        if (result instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)result;
            answer = new RoutesDefinition();
            JaxbHelper.applyNamespaces(route, namespaces);
            answer.getRoutes().add(route);
        } else if (result instanceof RoutesDefinition) {
            RoutesDefinition routesDefinition;
            answer = routesDefinition = (RoutesDefinition)result;
            for (RouteDefinition route : answer.getRoutes()) {
                JaxbHelper.applyNamespaces(route, namespaces);
            }
        } else {
            return null;
        }
        return answer;
    }

    public static RouteConfigurationsDefinition loadRouteConfigurationsDefinition(CamelContext context, InputStream inputStream) throws Exception {
        RouteConfigurationsDefinition answer;
        XmlConverter xmlConverter = JaxbHelper.newXmlConverter(context);
        Document dom = xmlConverter.toDOMDocument(inputStream, null);
        JaxbHelper.removeNoiseFromUris(dom.getDocumentElement());
        JAXBContext jaxbContext = JaxbHelper.getJAXBContext(context);
        Map<String, String> namespaces = JaxbHelper.doExtractNamespaces(dom);
        Binder binder = jaxbContext.createBinder();
        Object result = binder.unmarshal((Object)dom);
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to RouteConfigurationsDefinition using JAXB");
        }
        if (result instanceof RouteConfigurationDefinition) {
            RouteConfigurationDefinition config = (RouteConfigurationDefinition)result;
            answer = new RouteConfigurationsDefinition();
            JaxbHelper.applyNamespaces(config, namespaces);
            answer.getRouteConfigurations().add(config);
        } else if (result instanceof RouteConfigurationsDefinition) {
            RouteConfigurationsDefinition routeConfigurationsDefinition;
            answer = routeConfigurationsDefinition = (RouteConfigurationsDefinition)result;
            for (RouteConfigurationDefinition config : answer.getRouteConfigurations()) {
                JaxbHelper.applyNamespaces(config, namespaces);
            }
        } else {
            return null;
        }
        return answer;
    }

    public static RouteTemplatesDefinition loadRouteTemplatesDefinition(CamelContext context, InputStream inputStream) throws Exception {
        RouteTemplatesDefinition answer;
        XmlConverter xmlConverter = JaxbHelper.newXmlConverter(context);
        Document dom = xmlConverter.toDOMDocument(inputStream, null);
        JaxbHelper.removeNoiseFromUris(dom.getDocumentElement());
        JAXBContext jaxbContext = JaxbHelper.getJAXBContext(context);
        Map<String, String> namespaces = JaxbHelper.doExtractNamespaces(dom);
        Binder binder = jaxbContext.createBinder();
        Object result = binder.unmarshal((Object)dom);
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to RouteTemplatesDefinition using JAXB");
        }
        if (result instanceof RouteTemplateDefinition) {
            RouteTemplateDefinition route = (RouteTemplateDefinition)result;
            answer = new RouteTemplatesDefinition();
            JaxbHelper.applyNamespaces(route.getRoute(), namespaces);
            answer.getRouteTemplates().add(route);
        } else if (result instanceof RouteTemplatesDefinition) {
            RouteTemplatesDefinition routeTemplatesDefinition;
            answer = routeTemplatesDefinition = (RouteTemplatesDefinition)result;
            for (RouteTemplateDefinition route : answer.getRouteTemplates()) {
                JaxbHelper.applyNamespaces(route.getRoute(), namespaces);
            }
        } else {
            return null;
        }
        return answer;
    }

    private static Map<String, String> doExtractNamespaces(Document dom) {
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        JaxbHelper.extractNamespaces(dom, namespaces);
        if (!namespaces.containsValue(CAMEL_NS)) {
            JaxbHelper.addNamespaceToDom(dom);
        }
        return namespaces;
    }

    public static TemplatedRoutesDefinition loadTemplatedRoutesDefinition(CamelContext context, InputStream inputStream) throws Exception {
        TemplatedRoutesDefinition answer;
        XmlConverter xmlConverter = JaxbHelper.newXmlConverter(context);
        Document dom = xmlConverter.toDOMDocument(inputStream, null);
        JaxbHelper.removeNoiseFromUris(dom.getDocumentElement());
        JAXBContext jaxbContext = JaxbHelper.getJAXBContext(context);
        JaxbHelper.doExtractNamespaces(dom);
        Binder binder = jaxbContext.createBinder();
        Object result = binder.unmarshal((Object)dom);
        if (result == null) {
            throw new JAXBException("Cannot unmarshal to TemplatedRoutesDefinition using JAXB");
        }
        if (result instanceof TemplatedRouteDefinition) {
            TemplatedRouteDefinition templatedRoute = (TemplatedRouteDefinition)result;
            answer = new TemplatedRoutesDefinition();
            answer.getTemplatedRoutes().add(templatedRoute);
        } else if (result instanceof TemplatedRoutesDefinition) {
            TemplatedRoutesDefinition templatedRoutesDefinition;
            answer = templatedRoutesDefinition = (TemplatedRoutesDefinition)result;
        } else {
            return null;
        }
        return answer;
    }

    private static void addNamespaceToDom(Document dom) {
        Element root = dom.getDocumentElement();
        JaxbHelper.renameElementWithNamespace(dom, root, CAMEL_NS);
    }

    private static void renameElementWithNamespace(Document doc, Element elem, String camelNs) {
        doc.renameNode(elem, camelNs, elem.getLocalName());
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            JaxbHelper.renameElementWithNamespace(doc, (Element)child, camelNs);
        }
    }

    public static RestsDefinition loadRestsDefinition(CamelContext context, InputStream inputStream) throws Exception {
        RestsDefinition answer;
        Unmarshaller unmarshaller;
        Object result;
        Document dom = JaxbHelper.newXmlConverter(context).toDOMDocument(inputStream, null);
        JaxbHelper.removeNoiseFromUris(dom.getDocumentElement());
        if (!CAMEL_NS.equals(dom.getDocumentElement().getNamespaceURI())) {
            JaxbHelper.addNamespaceToDom(dom);
        }
        if ((result = (unmarshaller = JaxbHelper.getJAXBContext(context).createUnmarshaller()).unmarshal((Node)dom)) == null) {
            throw new IOException("Cannot unmarshal to rests using JAXB from input stream: " + inputStream);
        }
        if (result instanceof RestDefinition) {
            RestDefinition rest = (RestDefinition)result;
            answer = new RestsDefinition();
            answer.getRests().add(rest);
        } else if (result instanceof RestsDefinition) {
            RestsDefinition restsDefinition;
            answer = restsDefinition = (RestsDefinition)result;
        } else {
            return null;
        }
        return answer;
    }

    public static RestConfigurationDefinition loadRestConfigurationDefinition(CamelContext context, InputStream inputStream) throws Exception {
        Unmarshaller unmarshaller;
        Object result;
        Document dom = JaxbHelper.newXmlConverter(context).toDOMDocument(inputStream, null);
        if (!CAMEL_NS.equals(dom.getDocumentElement().getNamespaceURI())) {
            JaxbHelper.addNamespaceToDom(dom);
        }
        if ((result = (unmarshaller = JaxbHelper.getJAXBContext(context).createUnmarshaller()).unmarshal((Node)dom)) == null) {
            throw new IOException("Cannot unmarshal to rest configuration using JAXB from input stream: " + inputStream);
        }
        if (result instanceof RestConfigurationDefinition) {
            RestConfigurationDefinition restConfigurationDefinition = (RestConfigurationDefinition)result;
            return restConfigurationDefinition;
        }
        return null;
    }

    private static void removeNoiseFromUris(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        for (int index = 0; index < attrs.getLength(); ++index) {
            Attr attr = (Attr)attrs.item(index);
            String attName = attr.getName();
            if (!attName.equals("uri") && !attName.endsWith("Uri")) continue;
            attr.setValue(URISupport.removeNoiseFromUri((String)attr.getValue()));
        }
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node child = children.item(index);
            if (child.getNodeType() != 1) continue;
            JaxbHelper.removeNoiseFromUris((Element)child);
        }
    }

    public static void removeAutoAssignedIds(Element element) {
        NamedNodeMap attrs = element.getAttributes();
        Attr id = null;
        Attr customId = null;
        for (int index = 0; index < attrs.getLength(); ++index) {
            Attr attr = (Attr)attrs.item(index);
            String attName = attr.getName();
            if (attName.equals("id")) {
                id = attr;
                continue;
            }
            if (!attName.equals("customId")) continue;
            customId = attr;
        }
        if (id != null && customId == null) {
            attrs.removeNamedItem("id");
        }
        if (customId != null) {
            attrs.removeNamedItem("customId");
        }
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node child = children.item(index);
            if (child.getNodeType() != 1) continue;
            JaxbHelper.removeAutoAssignedIds((Element)child);
        }
    }

    public static void enrichLocations(Node node, Map<String, KeyValueHolder<Integer, String>> locations) {
        if (node instanceof Element) {
            KeyValueHolder<Integer, String> loc;
            Node parent;
            Element el = (Element)node;
            String id = el.getAttribute("id");
            if ("from".equals(el.getNodeName()) && (parent = el.getParentNode()) instanceof Element) {
                Element parentElement = (Element)parent;
                id = parentElement.getAttribute("id");
            }
            if ((loc = locations.get(id)) != null) {
                el.setAttribute("sourceLineNumber", ((Integer)loc.getKey()).toString());
                el.setAttribute("sourceLocation", (String)loc.getValue());
            }
        }
        if (node.hasChildNodes()) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node child = node.getChildNodes().item(i);
                JaxbHelper.enrichLocations(child, locations);
            }
        }
    }
}

