/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.out;

import java.io.IOException;
import java.io.Writer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.xml.io.XMLWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BaseWriter {
    protected final XMLWriter writer;
    protected final Deque<String> namespacesStack = new LinkedList<String>();
    protected boolean namespaceWritten;

    public BaseWriter(Writer writer, String namespace) throws IOException {
        this.writer = new XMLWriter(writer);
        this.namespacesStack.push(namespace);
    }

    protected void startElement(String name) throws IOException {
        this.writer.startElement(name);
        if (!this.namespaceWritten && this.namespacesStack.peek() != null) {
            this.writer.addAttribute("xmlns", this.namespacesStack.peek());
            this.namespaceWritten = true;
        }
    }

    protected void startElement(String name, String namespace) throws IOException {
        this.writer.startElement(name);
        if (!this.namespacesStack.isEmpty() && !namespace.equals(this.namespacesStack.peek())) {
            this.namespacesStack.push(namespace);
            this.writer.addAttribute("xmlns", namespace);
        }
    }

    protected void startOutputElement(String name) throws IOException {
        this.startElement(name);
    }

    protected void startExpressionElement(String name) throws IOException {
        this.startElement(name);
    }

    protected void endExpressionElement(String name) throws IOException {
        this.writer.endElement(name);
    }

    protected void endElement() throws IOException {
        this.writer.endElement(null);
    }

    protected void endElement(String namespace) throws IOException {
        this.endElement();
        if (!this.namespacesStack.isEmpty() && this.namespacesStack.peek().equals(namespace)) {
            this.namespacesStack.pop();
        }
    }

    protected void text(String text) throws IOException {
        this.writer.writeText(text);
    }

    protected void text(String name, String text) throws IOException {
        this.writer.writeText(text);
    }

    protected void value(String value) throws IOException {
        this.writer.writeText(value);
    }

    protected void attribute(String name, Object value) throws IOException {
        if (value != null) {
            this.writer.addAttribute(name, value.toString());
        }
    }

    protected void domElements(List<Element> elements) throws IOException {
        for (Element e : elements) {
            this.domElement(e);
        }
    }

    protected void domElement(Element v) throws IOException {
        if (v != null) {
            this.startElement(v.getTagName(), v.getNamespaceURI());
            NamedNodeMap nnm = v.getAttributes();
            if (nnm != null) {
                for (int i = 0; i < nnm.getLength(); ++i) {
                    Attr attr = (Attr)nnm.item(i);
                    this.attribute(attr.getName(), attr.getValue());
                }
            }
            NodeList children = v.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node item = children.item(i);
                if (item instanceof Element) {
                    this.domElement((Element)item);
                    continue;
                }
                if (!(item instanceof Text)) continue;
                this.text(((Text)item).getWholeText());
            }
            this.endElement(v.getNamespaceURI());
        }
    }
}

