/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xj;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.camel.component.xj.XJConstants;
import org.apache.camel.util.ObjectHelper;

public class JsonXmlStreamReader
implements XMLStreamReader {
    private static final String ERROR_MSG_NOT_IN_START_ELEMENT = "Current event is not start element";
    private static final String ERROR_MSG_NOT_IN_START_END_ELEMENT = "Current event is not start element";
    private static final String ERROR_MSG_NOT_IN_CHARACTERS = "Current event is not character";
    private static final Location LOCATION = new Location(){

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }
    };
    private final JsonParser jsonParser;
    private final Deque<StackElement> tokenStack = new ArrayDeque<StackElement>();
    private boolean eof;

    public JsonXmlStreamReader(JsonParser jsonParser) {
        this.jsonParser = jsonParser;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    @Override
    public int next() throws XMLStreamException {
        try {
            StackElement previousElement = this.tokenStack.peek();
            if (previousElement != null) {
                switch (previousElement.jsonToken) {
                    case VALUE_STRING: 
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_NULL: 
                    case VALUE_TRUE: 
                    case VALUE_FALSE: {
                        switch (previousElement.xmlEvent) {
                            case 1: {
                                previousElement.xmlEvent = 4;
                                return 4;
                            }
                            case 4: {
                                this.removeStackElement(previousElement.jsonToken);
                                this.removeStackElement(JsonToken.FIELD_NAME);
                                ObjectHelper.notNull((Object)this.tokenStack.peek(), (String)"tokenStack.peek()");
                                this.tokenStack.peek().xmlEvent = 2;
                                return 2;
                            }
                        }
                        throw new IllegalStateException("illegal state");
                    }
                }
            }
            if (this.eof) {
                return 8;
            }
            JsonToken currentToken = this.jsonParser.nextToken();
            if (currentToken == null) {
                throw new IllegalStateException("End of document");
            }
            StackElement stackElement = new StackElement(currentToken, this.toXmlString(this.jsonParser.getCurrentName()));
            this.tokenStack.push(stackElement);
            if (currentToken == JsonToken.FIELD_NAME) {
                currentToken = this.jsonParser.nextToken();
                stackElement = new StackElement(currentToken, this.toXmlString(this.jsonParser.getCurrentName()));
                this.tokenStack.push(stackElement);
            }
            switch (currentToken) {
                case VALUE_STRING: 
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NULL: 
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case START_OBJECT: 
                case START_ARRAY: {
                    stackElement.xmlEvent = 1;
                    return 1;
                }
                case END_OBJECT: {
                    this.removeStackElement(JsonToken.END_OBJECT);
                    this.removeStackElement(JsonToken.START_OBJECT);
                    this.removeStackElement(JsonToken.FIELD_NAME);
                    this.eof = this.tokenStack.isEmpty();
                    return 2;
                }
                case END_ARRAY: {
                    this.removeStackElement(JsonToken.END_ARRAY);
                    this.removeStackElement(JsonToken.START_ARRAY);
                    this.removeStackElement(JsonToken.FIELD_NAME);
                    this.eof = this.tokenStack.isEmpty();
                    return 2;
                }
            }
            throw new IllegalStateException("JsonToken: " + String.valueOf(currentToken));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void removeStackElement(JsonToken jsonToken) {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.jsonToken != jsonToken) {
            if (stackElement != null && jsonToken == JsonToken.FIELD_NAME && stackElement.jsonToken == JsonToken.START_ARRAY) {
                return;
            }
            if (stackElement == null && jsonToken == JsonToken.FIELD_NAME) {
                return;
            }
            String stackElements = this.tokenStack.stream().map(StackElement::toString).collect(Collectors.joining("\n"));
            throw new IllegalStateException("Stack element did not match expected (" + String.valueOf(jsonToken) + ") one. Stack:\n" + stackElements);
        }
        this.tokenStack.pop();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) {
        throw new UnsupportedOperationException("unsupported / not yet implemented");
    }

    @Override
    public String getElementText() {
        throw new UnsupportedOperationException("unsupported / not yet implemented");
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int evt;
        while ((evt = this.next()) != 1 && evt != 2) {
        }
        return evt;
    }

    @Override
    public boolean hasNext() {
        return !this.eof;
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.jsonParser.close();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public boolean isStartElement() {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null) {
            return false;
        }
        return stackElement.xmlEvent == 1;
    }

    @Override
    public boolean isEndElement() {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null) {
            return false;
        }
        return stackElement.xmlEvent == 2;
    }

    @Override
    public boolean isCharacters() {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null) {
            return false;
        }
        return stackElement.xmlEvent == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        throw new UnsupportedOperationException("unsupported / not yet implemented");
    }

    @Override
    public int getAttributeCount() {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.xmlEvent != 1) {
            throw new IllegalStateException("Current event is not start element");
        }
        return stackElement.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.xmlEvent != 1) {
            throw new IllegalStateException("Current event is not start element");
        }
        return stackElement.getAttribute(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.xmlEvent != 1) {
            throw new IllegalStateException("Current event is not start element");
        }
        return stackElement.getAttribute(index).getNamespaceURI();
    }

    @Override
    public String getAttributeLocalName(int index) {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.xmlEvent != 1) {
            throw new IllegalStateException("Current event is not start element");
        }
        return stackElement.getAttribute(index).getLocalPart();
    }

    @Override
    public String getAttributePrefix(int index) {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.xmlEvent != 1) {
            throw new IllegalStateException("Current event is not start element");
        }
        return stackElement.getAttribute(index).getPrefix();
    }

    @Override
    public String getAttributeType(int index) {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.xmlEvent != 1) {
            throw new IllegalStateException("Current event is not start element");
        }
        return "CDATA";
    }

    @Override
    public String getAttributeValue(int index) {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.xmlEvent != 1) {
            throw new IllegalStateException("Current event is not start element");
        }
        return this.tokenStack.peek().getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return false;
    }

    @Override
    public int getNamespaceCount() {
        if (this.tokenStack.size() == 1) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getNamespacePrefix(int index) {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.xmlEvent != 1 && stackElement.xmlEvent != 2) {
            throw new IllegalStateException("Current event is not start element");
        }
        return "xj";
    }

    @Override
    public String getNamespaceURI(int index) {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.xmlEvent != 1 && stackElement.xmlEvent != 2) {
            throw new IllegalStateException("Current event is not start element");
        }
        return "http://camel.apache.org/component/xj";
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException("unsupported / not yet implemented");
    }

    @Override
    public int getEventType() {
        if (this.eof) {
            return 8;
        }
        if (this.tokenStack.isEmpty()) {
            return 7;
        }
        return this.tokenStack.peek().xmlEvent;
    }

    @Override
    public String getText() {
        return new String(this.getTextCharacters());
    }

    @Override
    public char[] getTextCharacters() {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null || stackElement.xmlEvent != 4) {
            throw new IllegalStateException(ERROR_MSG_NOT_IN_CHARACTERS);
        }
        try {
            this.setXmlText(stackElement, this.jsonParser);
            return stackElement.value;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) {
        char[] text = this.getTextCharacters();
        System.arraycopy(text, sourceStart, target, targetStart, length);
        return sourceStart + length;
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public int getTextLength() {
        StackElement stackElement = this.tokenStack.peek();
        try {
            ObjectHelper.notNull((Object)stackElement, (String)"stackElement");
            this.setXmlText(stackElement, this.jsonParser);
            return stackElement.value.length;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void setXmlText(StackElement stackElement, JsonParser jsonParser) throws IOException {
        if (stackElement.value == null) {
            stackElement.value = this.toXmlString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
        }
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public boolean hasText() {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null) {
            return false;
        }
        return stackElement.xmlEvent == 4;
    }

    @Override
    public Location getLocation() {
        return LOCATION;
    }

    @Override
    public QName getName() {
        return new QName("object");
    }

    @Override
    public String getLocalName() {
        return "object";
    }

    @Override
    public boolean hasName() {
        StackElement stackElement = this.tokenStack.peek();
        if (stackElement == null) {
            return false;
        }
        return stackElement.xmlEvent == 1 || stackElement.xmlEvent == 2;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        return null;
    }

    @Override
    public String getPIData() {
        return null;
    }

    private String toXmlString(String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        char[] chars = input.toCharArray();
        return new String(this.toXmlString(chars, 0, chars.length));
    }

    private char[] toXmlString(char[] input, int offset, int length) {
        if (length == 0) {
            return new char[0];
        }
        char[] res = new char[length];
        int copied = 0;
        for (int i = offset; i < offset + length; ++i) {
            char cur = input[i];
            if (cur < '\t' || cur > '\n' && cur < '\r' || cur > '\r' && cur < ' ') continue;
            res[copied++] = cur;
        }
        return Arrays.copyOfRange(res, 0, copied);
    }

    private static class StackElement {
        private final JsonToken jsonToken;
        private final String name;
        private final List<QName> attributes;
        private int xmlEvent;
        private char[] value;

        StackElement(JsonToken jsonToken, String name) {
            this.jsonToken = jsonToken;
            this.name = name;
            this.attributes = new ArrayList<QName>(2);
            if (name != null) {
                QName nameAttribute = new QName("http://camel.apache.org/component/xj", "name", "xj");
                this.attributes.add(nameAttribute);
            }
            QName typeAttribute = new QName("http://camel.apache.org/component/xj", "type", "xj");
            this.attributes.add(typeAttribute);
        }

        int getAttributeCount() {
            return this.attributes.size();
        }

        QName getAttribute(int idx) {
            return this.attributes.get(idx);
        }

        String getAttributeValue(int idx) {
            QName attribute = this.getAttribute(idx);
            switch (attribute.getLocalPart()) {
                case "name": {
                    return this.name;
                }
                case "type": {
                    return XJConstants.JSONTYPE_TYPE_MAP.get(this.jsonToken);
                }
            }
            throw new IllegalArgumentException("Unknown attribute " + attribute.getLocalPart());
        }

        public String toString() {
            return "StackElement{jsonToken=" + String.valueOf(this.jsonToken) + ", name='" + this.name + "', xmlEvent=" + this.xmlEvent + ", value=" + Arrays.toString(this.value) + ", attributes=" + String.valueOf(this.attributes) + "}";
        }
    }
}

