/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weaviate;

import io.weaviate.client.Config;
import io.weaviate.client.WeaviateAuthClient;
import io.weaviate.client.WeaviateClient;
import io.weaviate.client.base.Result;
import io.weaviate.client.v1.auth.exception.AuthException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.weaviate.WeaviateVectorDb;
import org.apache.camel.component.weaviate.WeaviateVectorDbConfiguration;
import org.apache.camel.component.weaviate.WeaviateVectorDbProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.12.0", scheme="weaviate", title="weaviate", syntax="weaviate:collection", producerOnly=true, category={Category.DATABASE, Category.AI}, headersClass=WeaviateVectorDb.Headers.class)
public class WeaviateVectorDbEndpoint
extends DefaultEndpoint {
    @Metadata(required=true)
    @UriPath(description="The collection Name")
    private final String collection;
    @UriParam
    private WeaviateVectorDbConfiguration configuration;
    private WeaviateClient client;

    public WeaviateVectorDbEndpoint(String endpointUri, Component component, String collection, WeaviateVectorDbConfiguration configuration) {
        super(endpointUri, component);
        this.collection = collection;
        this.configuration = configuration;
    }

    public WeaviateVectorDbConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getCollection() {
        return this.collection;
    }

    public WeaviateClient getClient() throws AuthException {
        this.lock.lock();
        try {
            if (this.client == null) {
                this.client = this.configuration.getClient();
                if (this.client == null) {
                    this.client = this.createClient();
                }
            }
            WeaviateClient weaviateClient = this.client;
            return weaviateClient;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Producer createProducer() throws Exception {
        return new WeaviateVectorDbProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not implemented for this component");
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
    }

    private WeaviateClient createClient() throws AuthException {
        WeaviateClient weaviate;
        Result result;
        String scheme = this.configuration.getScheme();
        String host = this.configuration.getHost();
        Config config = new Config(scheme, host);
        if (this.configuration.getProxyHost() != null && this.configuration.getProxyPort() != null && this.configuration.getProxyScheme() != null) {
            config.setProxy(this.configuration.getProxyHost(), this.configuration.getProxyPort().intValue(), this.configuration.getProxyScheme());
        }
        if ((result = (weaviate = this.configuration.getApiKey() != null ? WeaviateAuthClient.apiKey((Config)config, (String)this.configuration.getApiKey()) : new WeaviateClient(config)).misc().readyChecker().run()).hasErrors()) {
            throw new AuthException(result.getError().toString());
        }
        return weaviate;
    }
}

