/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather.geolocation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.component.weather.WeatherConfiguration;
import org.apache.camel.component.weather.geolocation.GeoLocation;
import org.apache.camel.component.weather.geolocation.GeoLocationProvider;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class FreeGeoIpGeoLocationProvider
implements GeoLocationProvider {
    private final WeatherConfiguration configuration;

    public FreeGeoIpGeoLocationProvider(WeatherConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public GeoLocation getCurrentGeoLocation() throws Exception {
        CloseableHttpClient httpClient = this.configuration.getHttpClient();
        if (ObjectHelper.isEmpty((String)this.configuration.getGeolocationAccessKey())) {
            throw new IllegalStateException("The geolocation service requires a mandatory geolocationAccessKey");
        }
        if (ObjectHelper.isEmpty((String)this.configuration.getGeolocationRequestHostIP())) {
            throw new IllegalStateException("The geolocation service requires a mandatory geolocationRequestHostIP");
        }
        String url = String.format("http://api.ipstack.com/%s?access_key=%s&legacy=1&output=json", this.configuration.getGeolocationRequestHostIP(), this.configuration.getGeolocationAccessKey());
        HttpGet getMethod = new HttpGet(url);
        return (GeoLocation)httpClient.execute((ClassicHttpRequest)getMethod, response -> {
            try {
                if (response.getCode() != 200) {
                    throw new IllegalStateException("Got the unexpected http-status '" + response.getCode() + "' for the geolocation");
                }
                String geoLocation = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                if (ObjectHelper.isEmpty((String)geoLocation)) {
                    throw new IllegalStateException("Got the unexpected value '" + geoLocation + "' for the geolocation");
                }
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = (JsonNode)mapper.readValue(geoLocation, JsonNode.class);
                JsonNode latitudeNode = (JsonNode)ObjectHelper.notNull((Object)node.get("latitude"), (String)"latitude");
                JsonNode longitudeNode = (JsonNode)ObjectHelper.notNull((Object)node.get("longitude"), (String)"longitude");
                GeoLocation geoLocation2 = new GeoLocation(longitudeNode.asText(), latitudeNode.asText());
                return geoLocation2;
            }
            finally {
                getMethod.reset();
            }
        });
    }
}

