/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.weather.WeatherEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeatherConsumer
extends ScheduledPollConsumer {
    public static final long DEFAULT_CONSUMER_DELAY = 3600000L;
    private static final Logger LOG = LoggerFactory.getLogger(WeatherConsumer.class);
    private String query;

    public WeatherConsumer(WeatherEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public WeatherEndpoint getEndpoint() {
        return (WeatherEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.query = this.getEndpoint().getWeatherQuery().getQuery();
    }

    protected int poll() throws Exception {
        LOG.debug("Going to execute the Weather query {}", (Object)this.query);
        CloseableHttpClient httpClient = this.getEndpoint().getConfiguration().getHttpClient();
        HttpGet getMethod = new HttpGet(this.query);
        try {
            return (Integer)httpClient.execute((ClassicHttpRequest)getMethod, response -> {
                try {
                    if (200 != response.getCode()) {
                        LOG.warn("HTTP call for weather returned error status code {} - {} as a result with query: {}", new Object[]{this.status, response.getCode(), this.query});
                        Integer n = 0;
                        return n;
                    }
                    String weather = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    LOG.debug("Got back the Weather information {}", (Object)weather);
                    if (ObjectHelper.isEmpty((String)weather)) {
                        Integer n = 0;
                        return n;
                    }
                    Exchange exchange = this.getEndpoint().createExchange();
                    String header = this.getEndpoint().getConfiguration().getHeaderName();
                    if (header != null) {
                        exchange.getIn().setHeader(header, (Object)weather);
                    } else {
                        exchange.getIn().setBody((Object)weather);
                    }
                    exchange.getIn().setHeader("CamelWeatherQuery", (Object)this.query);
                    try {
                        this.getProcessor().process(exchange);
                    }
                    catch (Exception e) {
                        throw new RuntimeCamelException((Throwable)e);
                    }
                    Integer n = 1;
                    return n;
                }
                finally {
                    getMethod.reset();
                }
            });
        }
        catch (RuntimeCamelException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Exception) {
                Exception ex = (Exception)throwable;
                throw ex;
            }
            throw e;
        }
    }
}

