/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.net.TCPSSLOptions;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.vertx.common.VertxHelper;
import org.apache.camel.component.vertx.websocket.VertxWebsocketClientConsumer;
import org.apache.camel.component.vertx.websocket.VertxWebsocketComponent;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConfiguration;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConstants;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConsumer;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHelper;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHost;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostKey;
import org.apache.camel.component.vertx.websocket.VertxWebsocketPeer;
import org.apache.camel.component.vertx.websocket.VertxWebsocketProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.5.0", scheme="vertx-websocket", title="Vert.x WebSocket", syntax="vertx-websocket:host:port/path", category={Category.HTTP, Category.NETWORKING}, headersClass=VertxWebsocketConstants.class, lenientProperties=true)
public class VertxWebsocketEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(VertxWebsocketEndpoint.class);
    @UriParam
    private VertxWebsocketConfiguration configuration;
    private HttpClient client;
    private WebSocket webSocket;

    public VertxWebsocketEndpoint(String uri, VertxWebsocketComponent component, VertxWebsocketConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public String getServiceUrl() {
        return this.configuration.getHost() + ":" + this.configuration.getPort();
    }

    public String getServiceProtocol() {
        return "websocket";
    }

    public boolean isLenientProperties() {
        return true;
    }

    public VertxWebsocketComponent getComponent() {
        return (VertxWebsocketComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        return new VertxWebsocketProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DefaultConsumer consumer = this.getConfiguration().isConsumeAsClient() ? new VertxWebsocketClientConsumer((Endpoint)this, processor) : new VertxWebsocketConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doStop() throws Exception {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.close();
            this.webSocket = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        super.doStop();
    }

    public VertxWebsocketConfiguration getConfiguration() {
        return this.configuration;
    }

    protected Vertx getVertx() {
        return this.getComponent().getVertx();
    }

    protected WebSocket getWebSocket() throws Exception {
        SSLContextParameters sslContextParameters;
        if (this.client == null) {
            HttpClientOptions options = this.configuration.getClientOptions();
            if (options == null) {
                options = new HttpClientOptions();
            }
            if ((sslContextParameters = this.configuration.getSslContextParameters()) != null) {
                VertxHelper.setupSSLOptions((CamelContext)this.getCamelContext(), (SSLContextParameters)sslContextParameters, (TCPSSLOptions)options);
            }
            this.client = this.getVertx().createHttpClient(options);
        }
        if (this.webSocket == null || this.webSocket.isClosed()) {
            HttpClientOptions clientOptions = this.configuration.getClientOptions();
            if (clientOptions == null) {
                clientOptions = new HttpClientOptions();
            }
            if ((sslContextParameters = this.configuration.getSslContextParameters()) != null) {
                VertxHelper.setupSSLOptions((CamelContext)this.getCamelContext(), (SSLContextParameters)sslContextParameters, (TCPSSLOptions)clientOptions);
            }
            WebSocketConnectOptions connectOptions = this.getWebSocketConnectOptions(clientOptions);
            CompletableFuture future = new CompletableFuture();
            this.client.webSocket(connectOptions, result -> {
                if (!result.failed()) {
                    LOG.info("Connected to WebSocket on {}", (Object)((WebSocket)result.result()).remoteAddress());
                    future.complete((WebSocket)result.result());
                } else {
                    this.webSocket = null;
                    future.completeExceptionally(result.cause());
                }
            });
            this.webSocket = (WebSocket)future.get(clientOptions.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }
        return this.webSocket;
    }

    protected WebSocket getWebSocket(Exchange exchange) throws Exception {
        return this.getWebSocket().exceptionHandler(event -> exchange.setException(event.getCause()));
    }

    protected WebSocketConnectOptions getWebSocketConnectOptions(HttpClientOptions options) {
        URI websocketURI = this.configuration.getWebsocketURI();
        WebSocketConnectOptions connectOptions = new WebSocketConnectOptions();
        connectOptions.setHost(websocketURI.getHost());
        connectOptions.setURI(URISupport.pathAndQueryOf((URI)websocketURI));
        connectOptions.setSsl(Boolean.valueOf(options.isSsl() || websocketURI.getScheme().length() == 3));
        if (websocketURI.getPort() > 0) {
            connectOptions.setPort(Integer.valueOf(websocketURI.getPort()));
        } else {
            connectOptions.setPort(Integer.valueOf(connectOptions.isSsl() != false ? 443 : 80));
        }
        String subProtocols = this.configuration.getClientSubProtocols();
        if (ObjectHelper.isNotEmpty((String)subProtocols)) {
            connectOptions.setSubProtocols(Arrays.asList(subProtocols.split(",")));
        }
        connectOptions.setAllowOriginHeader(this.configuration.isAllowOriginHeader());
        String defaultOriginHeader = this.configuration.getOriginHeaderUrl();
        if (ObjectHelper.isNotEmpty((String)defaultOriginHeader)) {
            connectOptions.addHeader("Origin", defaultOriginHeader);
        }
        if (ObjectHelper.isNotEmpty(this.configuration.getHandshakeHeaders())) {
            this.configuration.getHandshakeHeaders().forEach((headerName, headerValue) -> connectOptions.addHeader(headerName, headerValue.toString()));
        }
        return connectOptions;
    }

    protected Map<VertxWebsocketHostKey, VertxWebsocketHost> getVertxHostRegistry() {
        return this.getComponent().getVertxHostRegistry();
    }

    protected ServerWebSocket findPeerForConnectionKey(String connectionKey) {
        Map<VertxWebsocketHostKey, VertxWebsocketHost> registry = this.getVertxHostRegistry();
        for (VertxWebsocketHost host : registry.values()) {
            VertxWebsocketPeer peer = host.getConnectedPeer(connectionKey);
            if (peer == null || !host.isManagedHost(this.getConfiguration().getWebsocketURI().getHost()) || !host.isManagedPort(this.getConfiguration().getWebsocketURI().getPort())) continue;
            return peer.getWebSocket();
        }
        return null;
    }

    protected Map<String, ServerWebSocket> findPeersForHostPort() {
        return this.getVertxHostRegistry().values().stream().filter(host -> host.isManagedHost(this.getConfiguration().getWebsocketURI().getHost())).filter(host -> host.isManagedPort(this.getConfiguration().getWebsocketURI().getPort())).flatMap(host -> host.getConnectedPeers().stream()).filter(connectedPeer -> {
            String producerPath = this.getConfiguration().getWebsocketURI().getPath();
            String peerConnectedPath = producerPath.contains("{") || producerPath.contains("*") ? connectedPeer.getRawPath() : connectedPeer.getPath();
            return VertxWebsocketHelper.webSocketHostPathMatches(peerConnectedPath, producerPath);
        }).collect(Collectors.toMap(VertxWebsocketPeer::getConnectionKey, VertxWebsocketPeer::getWebSocket));
    }
}

