/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.multipart.MultipartForm;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.vertx.common.VertxBufferConverter;
import org.apache.camel.component.vertx.http.VertxHttpBinding;
import org.apache.camel.component.vertx.http.VertxHttpComponent;
import org.apache.camel.component.vertx.http.VertxHttpEndpoint;
import org.apache.camel.component.vertx.http.VertxHttpHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.MimeTypeHelper;
import org.apache.camel.util.URISupport;

public class VertxHttpProducer
extends DefaultAsyncProducer {
    private final VertxHttpBinding vertxHttpBinding;

    public VertxHttpProducer(VertxHttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.vertxHttpBinding = endpoint.getConfiguration().getVertxHttpBinding();
    }

    public VertxHttpEndpoint getEndpoint() {
        return (VertxHttpEndpoint)super.getEndpoint();
    }

    public VertxHttpComponent getComponent() {
        return this.getEndpoint().getComponent();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        block26: {
            Message message = exchange.getMessage();
            try {
                HttpRequest<Buffer> request = this.vertxHttpBinding.prepareHttpRequest(this.getEndpoint(), exchange);
                Handler<AsyncResult<HttpResponse<Buffer>>> resultHandler = this.createResultHandler(exchange, callback);
                Object body = message.getBody();
                if (body == null) {
                    request.send(resultHandler);
                    break block26;
                }
                String contentType = MessageHelper.getContentType((Message)message);
                boolean multipart = this.getEndpoint().getConfiguration().isMultipartUpload();
                String multipartName = this.getEndpoint().getConfiguration().getMultipartUploadName();
                if (body instanceof MultiMap) {
                    MultiMap mm = (MultiMap)body;
                    request.sendForm(mm, resultHandler);
                    return false;
                }
                if (body instanceof MultipartForm) {
                    MultipartForm mf = (MultipartForm)body;
                    request.sendMultipartForm(mf, resultHandler);
                    return false;
                }
                if (body instanceof ReadStream) {
                    ReadStream rs = (ReadStream)body;
                    request.sendStream(rs, resultHandler);
                    return false;
                }
                if (body instanceof Buffer) {
                    Buffer buf = (Buffer)body;
                    request.sendBuffer(buf, resultHandler);
                    return false;
                }
                if (body instanceof File || body instanceof WrappedFile) {
                    File file = (File)message.getBody(File.class);
                    if (file == null) break block26;
                    try (FileInputStream is = new FileInputStream(file);){
                        Buffer buf = VertxBufferConverter.toBuffer((InputStream)is);
                        if (multipart) {
                            String type = MimeTypeHelper.probeMimeType((String)file.getName());
                            if (type == null) {
                                type = "application/octet-stream";
                            }
                            MultipartForm form = MultipartForm.create().binaryFileUpload(multipartName, file.getName(), buf, type);
                            request.sendMultipartForm(form, resultHandler);
                        } else {
                            request.sendBuffer(buf, resultHandler);
                        }
                        break block26;
                    }
                }
                if (body instanceof String) {
                    String str = (String)body;
                    if ("application/x-www-form-urlencoded".equals(contentType)) {
                        MultiMap map = MultiMap.caseInsensitiveMultiMap();
                        Map formParams = URISupport.parseQuery((String)str);
                        formParams.forEach((key, o) -> map.add(key, String.valueOf(o)));
                        request.sendForm(map, resultHandler);
                    } else {
                        Buffer buffer = VertxBufferConverter.toBuffer((String)str, (Exchange)exchange);
                        request.sendBuffer(buffer, resultHandler);
                    }
                    break block26;
                }
                if ("application/x-java-serialized-object".equals(contentType)) {
                    if (!this.getComponent().isAllowJavaSerializedObject()) {
                        throw new CamelExchangeException("Content-type application/x-java-serialized-object is not allowed", exchange);
                    }
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        Serializable serializable = (Serializable)message.getMandatoryBody(Serializable.class);
                        VertxHttpHelper.writeObjectToStream(baos, serializable);
                        request.sendBuffer(Buffer.buffer((byte[])baos.toByteArray()), resultHandler);
                        break block26;
                    }
                }
                Buffer buffer = (Buffer)message.getMandatoryBody(Buffer.class);
                request.sendBuffer(buffer, resultHandler);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
        }
        return false;
    }

    private Handler<AsyncResult<HttpResponse<Buffer>>> createResultHandler(Exchange exchange, AsyncCallback callback) {
        return response -> this.getEndpoint().getVertx().executeBlocking(() -> {
            try {
                this.vertxHttpBinding.handleResponse(this.getEndpoint(), exchange, (AsyncResult<HttpResponse<Buffer>>)response);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            finally {
                callback.done(false);
            }
            return null;
        });
    }
}

