/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.velocity;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.velocity.VelocityEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.velocity.app.VelocityEngine;

@Component(value="velocity")
public class VelocityComponent
extends DefaultComponent {
    @Metadata(defaultValue="true", description="Sets whether to use resource content cache or not")
    private boolean contentCache = true;
    @Metadata
    private boolean allowTemplateFromHeader;
    @Metadata
    private boolean allowContextMapAll;
    @Metadata(label="advanced", autowired=true)
    private VelocityEngine velocityEngine;

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public boolean isAllowContextMapAll() {
        return this.allowContextMapAll;
    }

    public void setAllowContextMapAll(boolean allowContextMapAll) {
        this.allowContextMapAll = allowContextMapAll;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, this.contentCache);
        VelocityEndpoint answer = new VelocityEndpoint(uri, this, remaining);
        answer.setContentCache(cache);
        answer.setVelocityEngine(this.velocityEngine);
        answer.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        answer.setAllowContextMapAll(this.allowContextMapAll);
        this.setProperties((Endpoint)answer, parameters);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }
}

