/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.velocity;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceBasedEndpoint;
import org.apache.camel.component.velocity.VelocityComponent;
import org.apache.camel.util.ExchangeHelper;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityEndpoint
extends ResourceBasedEndpoint {
    private final VelocityComponent component;
    private VelocityEngine velocityEngine;

    public VelocityEndpoint(String uri, VelocityComponent component, String resourceUri, Map parameters) {
        super(uri, (Component)component, resourceUri, null);
        this.component = component;
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    public VelocityEngine getVelocityEngine() throws Exception {
        if (this.velocityEngine == null) {
            this.velocityEngine = this.component.getVelocityEngine();
            this.velocityEngine.init();
        }
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    protected void onExchange(Exchange exchange) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getResource().getInputStream());
        StringWriter buffer = new StringWriter();
        String logTag = ((Object)((Object)this)).getClass().getName();
        Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange);
        VelocityContext velocityContext = new VelocityContext(variableMap);
        VelocityEngine engine = this.getVelocityEngine();
        engine.evaluate((Context)velocityContext, (Writer)buffer, logTag, (Reader)reader);
        Message out = exchange.getOut(true);
        out.setBody((Object)buffer.toString());
        out.setHeader("org.apache.camel.velocity.resource", (Object)this.getResource());
    }
}

