/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ImportantHeaderUtils {
    private static final Set<String> IMPORTANT_HEADER_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("CamelAggregatedCorrelationKey", "CamelAggregatedSize", "CamelAsteriskEventName", "CamelExecExitValue", "CamelFileLength", "CamelFileName", "CamelFtpReplyCode", "CamelFtpReplyString", "CamelHttpResponseCode", "CamelHttpResponseText", "CamelMqttTopic", "CamelNatsSID", "CamelNatsStatusCode", "CamelNatsStatusError", "CamelNettyRemoteAddress", "CamelRockerMQKey", "CamelSplitIndex", "CamelSplitSize", "CamelSqlRowCount", "CamelSqlStoredUpdateCount", "CamelSqlUpdateCount", "CamelSshExitValue", "Content-Type", "kafka.KEY", "kafka.OFFSET", "kafka.PARTITION", "kafka.TOPIC", "websocket.eventType")));

    private ImportantHeaderUtils() {
    }

    public static Set<String> getImportantHeaderKeys() {
        return IMPORTANT_HEADER_KEYS;
    }

    public static boolean isImportantHeader(String key) {
        return IMPORTANT_HEADER_KEYS.contains(key);
    }
}

