/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import org.apache.camel.spi.Metadata;

public final class UndertowConstants {
    @Metadata(javaType="String")
    public static final String CONNECTION_KEY = "websocket.connectionKey";
    @Metadata(label="producer", description="The list of websocket connection keys", javaType="List<String>")
    public static final String CONNECTION_KEY_LIST = "websocket.connectionKey.list";
    @Metadata(javaType="Boolean")
    public static final String SEND_TO_ALL = "websocket.sendToAll";
    @Metadata(label="consumer", description="The numeric identifier of the type of websocket event", javaType="Integer")
    public static final String EVENT_TYPE = "websocket.eventType";
    @Metadata(label="consumer", description="The type of websocket event", javaType="org.apache.camel.component.undertow.UndertowConstants.EventType")
    public static final String EVENT_TYPE_ENUM = "websocket.eventTypeEnum";
    @Metadata(label="consumer", javaType="io.undertow.websockets.core.WebSocketChannel")
    public static final String CHANNEL = "websocket.channel";
    @Metadata(label="consumer", description="The exchange for the websocket transport, only available for ON_OPEN events", javaType="io.undertow.websockets.spi.WebSocketHttpExchange")
    public static final String EXCHANGE = "websocket.exchange";
    @Metadata(description="The http response code", javaType="Integer")
    public static final String HTTP_RESPONSE_CODE = "CamelHttpResponseCode";
    @Metadata(description="The content type", javaType="String")
    public static final String CONTENT_TYPE = "Content-Type";
    @Metadata(label="consumer", description="The http character encoding", javaType="String")
    public static final String HTTP_CHARACTER_ENCODING = "CamelHttpCharacterEncoding";
    @Metadata(description="The http path", javaType="String")
    public static final String HTTP_PATH = "CamelHttpPath";
    @Metadata(description="The http query", javaType="String")
    public static final String HTTP_QUERY = "CamelHttpQuery";
    @Metadata(description="The http URI", javaType="String")
    public static final String HTTP_URI = "CamelHttpUri";
    @Metadata(label="producer", description="The http method", javaType="String")
    public static final String HTTP_METHOD = "CamelHttpMethod";
    @Metadata(label="producer", description="The host http header", javaType="String")
    public static final String HOST_STRING = "Host";
    public static final String WS_PROTOCOL = "ws";
    public static final String WSS_PROTOCOL = "wss";

    private UndertowConstants() {
    }

    public static enum EventType {
        ONOPEN(1),
        ONCLOSE(0),
        ONERROR(-1);

        private final int code;

        private EventType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static EventType ofCode(int code) {
            switch (code) {
                case 1: {
                    return ONOPEN;
                }
                case 0: {
                    return ONCLOSE;
                }
                case -1: {
                    return ONERROR;
                }
            }
            throw new IllegalArgumentException("Cannot find an " + EventType.class.getName() + " for code " + code);
        }
    }
}

