/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twilio;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class TwilioEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":apiName/methodName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "twilio".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "apiName", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "methodName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(64);
        props.add("apiName");
        props.add("applicationSid");
        props.add("areaCode");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("body");
        props.add("bridgeErrorHandler");
        props.add("callbackUrl");
        props.add("city");
        props.add("credentialListSid");
        props.add("customerName");
        props.add("delay");
        props.add("domainName");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("friendlyName");
        props.add("from");
        props.add("greedy");
        props.add("inBody");
        props.add("initialDelay");
        props.add("ipAccessControlListSid");
        props.add("ipAddress");
        props.add("isoCountry");
        props.add("lazyStartProducer");
        props.add("mediaUrl");
        props.add("messagingServiceSid");
        props.add("methodName");
        props.add("password");
        props.add("pathAccountSid");
        props.add("pathAddOnResultSid");
        props.add("pathAddressSid");
        props.add("pathCallSid");
        props.add("pathConferenceSid");
        props.add("pathCountryCode");
        props.add("pathCredentialListSid");
        props.add("pathDomainSid");
        props.add("pathIpAccessControlListSid");
        props.add("pathMessageSid");
        props.add("pathQueueSid");
        props.add("pathRecordingSid");
        props.add("pathReferenceSid");
        props.add("pathSid");
        props.add("phoneNumber");
        props.add("pollStrategy");
        props.add("postalCode");
        props.add("region");
        props.add("repeatCount");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("sendEmptyMessageWhenIdle");
        props.add("startScheduler");
        props.add("status");
        props.add("street");
        props.add("timeUnit");
        props.add("to");
        props.add("triggerValue");
        props.add("twiml");
        props.add("url");
        props.add("usageCategory");
        props.add("useFixedDelay");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashMap<String, String> prefixes = new HashMap<String, String>(1);
        prefixes.put("schedulerProperties", "scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableMap(prefixes);
    }
}

