/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.decorators.AbstractSpanDecorator;

public class ElasticsearchSpanDecorator
extends AbstractSpanDecorator {
    public static final String ELASTICSEARCH_DB_TYPE = "elasticsearch";
    @Deprecated
    public static final String ELASTICSEARCH_CLUSTER_TAG = "elasticsearch.cluster";

    @Override
    public String getComponent() {
        return ELASTICSEARCH_DB_TYPE;
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.es.ElasticsearchComponent";
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        Map<String, String> queryParameters = ElasticsearchSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
        String answer = queryParameters.containsKey("operation") ? queryParameters.get("operation") : super.getOperationName(exchange, endpoint);
        return ElasticsearchSpanDecorator.clipMaxLength(answer);
    }

    @Override
    public void pre(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        super.pre(span, exchange, endpoint);
        span.setTag("db.system", ELASTICSEARCH_DB_TYPE);
        Map<String, String> queryParameters = ElasticsearchSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
        if (queryParameters.containsKey("indexName")) {
            span.setTag("db.name", queryParameters.get("indexName"));
        }
        String cluster = ElasticsearchSpanDecorator.stripSchemeAndOptions(endpoint);
        span.setTag(ELASTICSEARCH_CLUSTER_TAG, cluster);
    }
}

