/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.decorators.AbstractHttpSpanDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSpanDecorator
extends AbstractHttpSpanDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(RestSpanDecorator.class);

    @Override
    public String getComponent() {
        return "rest";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.rest.RestComponent";
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return RestSpanDecorator.getPath(endpoint.getEndpointUri());
    }

    @Override
    public void pre(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        super.pre(span, exchange, endpoint);
        RestSpanDecorator.getParameters(RestSpanDecorator.getPath(endpoint.getEndpointUri())).forEach(param -> {
            Object value = exchange.getIn().getHeader(param);
            if (value != null) {
                if (value instanceof String) {
                    span.setTag((String)param, (String)value);
                } else if (value instanceof Number) {
                    span.setTag((String)param, (Number)value);
                } else if (value instanceof Boolean) {
                    span.setTag((String)param, (Boolean)value);
                }
            }
        });
    }

    protected static String getPath(String uri) {
        String path = null;
        int index = uri.indexOf(58);
        if (index != -1 && (index = uri.indexOf(58, index + 1)) != -1) {
            path = uri.substring(index + 1);
            if ((index = path.indexOf(63)) != -1) {
                path = path.substring(0, index);
            }
            path = path.replace(":", "");
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.debug("Failed to decode URL path '" + path + "', ignoring exception", (Throwable)e);
            }
        }
        return path;
    }

    protected static List<String> getParameters(String path) {
        ArrayList<String> parameters = null;
        int startIndex = path.indexOf(123);
        while (startIndex != -1) {
            int endIndex = path.indexOf(125, startIndex);
            if (endIndex != -1) {
                if (parameters == null) {
                    parameters = new ArrayList<String>();
                }
                parameters.add(path.substring(startIndex + 1, endIndex));
                startIndex = path.indexOf(123, endIndex);
                continue;
            }
            startIndex = -1;
        }
        return parameters == null ? Collections.emptyList() : parameters;
    }
}

