/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class TorchServeEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":api/operation";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "torchserve".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "api", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "operation", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(20);
        props.add("api");
        props.add("inferenceAddress");
        props.add("inferenceKey");
        props.add("inferencePort");
        props.add("lazyStartProducer");
        props.add("listLimit");
        props.add("listNextPageToken");
        props.add("managementAddress");
        props.add("managementKey");
        props.add("managementPort");
        props.add("metricsAddress");
        props.add("metricsName");
        props.add("metricsPort");
        props.add("modelName");
        props.add("modelVersion");
        props.add("operation");
        props.add("registerOptions");
        props.add("scaleWorkerOptions");
        props.add("unregisterOptions");
        props.add("url");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptyMap();
    }
}

