/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.client.management.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.camel.component.torchserve.client.management.invoker.ApiClient;
import org.apache.camel.component.torchserve.client.management.invoker.ApiException;
import org.apache.camel.component.torchserve.client.management.invoker.BaseApi;
import org.apache.camel.component.torchserve.client.management.invoker.Configuration;
import org.apache.camel.component.torchserve.client.management.invoker.Pair;
import org.apache.camel.component.torchserve.client.management.model.ApiDescription200Response;
import org.apache.camel.component.torchserve.client.management.model.DescribeModel200ResponseInner;
import org.apache.camel.component.torchserve.client.management.model.ListModels200Response;
import org.apache.camel.component.torchserve.client.management.model.Metrics200Response;
import org.apache.camel.component.torchserve.client.management.model.RegisterModel200Response;

public class DefaultApi
extends BaseApi {
    public DefaultApi() {
        super(Configuration.getDefaultApiClient());
    }

    public DefaultApi(ApiClient apiClient) {
        super(apiClient);
    }

    public ApiDescription200Response apiDescription() throws ApiException {
        return this.apiDescription(Collections.emptyMap());
    }

    public ApiDescription200Response apiDescription(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ApiDescription200Response> localVarReturnType = new TypeReference<ApiDescription200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Deprecated
    public ApiDescription200Response apiDescription_0() throws ApiException {
        return this.apiDescription_0(Collections.emptyMap());
    }

    @Deprecated
    public ApiDescription200Response apiDescription_0(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api-description";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ApiDescription200Response> localVarReturnType = new TypeReference<ApiDescription200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<DescribeModel200ResponseInner> describeModel(String modelName) throws ApiException {
        return this.describeModel(modelName, Collections.emptyMap());
    }

    public List<DescribeModel200ResponseInner> describeModel(String modelName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (modelName == null) {
            throw new ApiException(400, "Missing the required parameter 'modelName' when calling describeModel");
        }
        String localVarPath = "/models/{model_name}".replaceAll("\\{model_name\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<List<DescribeModel200ResponseInner>> localVarReturnType = new TypeReference<List<DescribeModel200ResponseInner>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ListModels200Response listModels(Integer limit, String nextPageToken) throws ApiException {
        return this.listModels(limit, nextPageToken, Collections.emptyMap());
    }

    public ListModels200Response listModels(Integer limit, String nextPageToken, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/models";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("next_page_token", nextPageToken));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ListModels200Response> localVarReturnType = new TypeReference<ListModels200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Metrics200Response metrics(String name) throws ApiException {
        return this.metrics(name, Collections.emptyMap());
    }

    public Metrics200Response metrics(String name, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/metrics";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name[]", name));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"text/plain; version=0.0.4; charset=utf-8", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<Metrics200Response> localVarReturnType = new TypeReference<Metrics200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RegisterModel200Response registerModel(String url, String modelName, String handler, String runtime, Integer batchSize, Integer maxBatchDelay, Integer responseTimeout, Integer startupTimeout, Integer initialWorkers, Boolean synchronous, Boolean s3SseKms, Object body) throws ApiException {
        return this.registerModel(url, modelName, handler, runtime, batchSize, maxBatchDelay, responseTimeout, startupTimeout, initialWorkers, synchronous, s3SseKms, body, Collections.emptyMap());
    }

    public RegisterModel200Response registerModel(String url, String modelName, String handler, String runtime, Integer batchSize, Integer maxBatchDelay, Integer responseTimeout, Integer startupTimeout, Integer initialWorkers, Boolean synchronous, Boolean s3SseKms, Object body, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;
        if (url == null) {
            throw new ApiException(400, "Missing the required parameter 'url' when calling registerModel");
        }
        String localVarPath = "/models";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("url", url));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("model_name", modelName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("handler", handler));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("runtime", runtime));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("batch_size", batchSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("max_batch_delay", maxBatchDelay));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("response_timeout", responseTimeout));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startup_timeout", startupTimeout));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("initial_workers", initialWorkers));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("synchronous", synchronous));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("s3_sse_kms", s3SseKms));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RegisterModel200Response setAutoScale(String modelName, Integer minWorker, Integer maxWorker, Integer numberGpu, Boolean synchronous, Integer timeout) throws ApiException {
        return this.setAutoScale(modelName, minWorker, maxWorker, numberGpu, synchronous, timeout, Collections.emptyMap());
    }

    public RegisterModel200Response setAutoScale(String modelName, Integer minWorker, Integer maxWorker, Integer numberGpu, Boolean synchronous, Integer timeout, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (modelName == null) {
            throw new ApiException(400, "Missing the required parameter 'modelName' when calling setAutoScale");
        }
        String localVarPath = "/models/{model_name}".replaceAll("\\{model_name\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("min_worker", minWorker));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("max_worker", maxWorker));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("number_gpu", numberGpu));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("synchronous", synchronous));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("timeout", timeout));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RegisterModel200Response setDefault(String modelName, String modelVersion) throws ApiException {
        return this.setDefault(modelName, modelVersion, Collections.emptyMap());
    }

    public RegisterModel200Response setDefault(String modelName, String modelVersion, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (modelName == null) {
            throw new ApiException(400, "Missing the required parameter 'modelName' when calling setDefault");
        }
        if (modelVersion == null) {
            throw new ApiException(400, "Missing the required parameter 'modelVersion' when calling setDefault");
        }
        String localVarPath = "/models/{model_name}/{model_version}/set-default".replaceAll("\\{model_name\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelName))).replaceAll("\\{model_version\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelVersion)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RegisterModel200Response unregisterModel(String modelName, Boolean synchronous, Integer timeout) throws ApiException {
        return this.unregisterModel(modelName, synchronous, timeout, Collections.emptyMap());
    }

    public RegisterModel200Response unregisterModel(String modelName, Boolean synchronous, Integer timeout, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (modelName == null) {
            throw new ApiException(400, "Missing the required parameter 'modelName' when calling unregisterModel");
        }
        String localVarPath = "/models/{model_name}".replaceAll("\\{model_name\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("synchronous", synchronous));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("timeout", timeout));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<DescribeModel200ResponseInner> versionDescribeModel(String modelName, String modelVersion) throws ApiException {
        return this.versionDescribeModel(modelName, modelVersion, Collections.emptyMap());
    }

    public List<DescribeModel200ResponseInner> versionDescribeModel(String modelName, String modelVersion, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (modelName == null) {
            throw new ApiException(400, "Missing the required parameter 'modelName' when calling versionDescribeModel");
        }
        if (modelVersion == null) {
            throw new ApiException(400, "Missing the required parameter 'modelVersion' when calling versionDescribeModel");
        }
        String localVarPath = "/models/{model_name}/{model_version}".replaceAll("\\{model_name\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelName))).replaceAll("\\{model_version\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelVersion)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<List<DescribeModel200ResponseInner>> localVarReturnType = new TypeReference<List<DescribeModel200ResponseInner>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RegisterModel200Response versionSetAutoScale(String modelName, String modelVersion, Integer minWorker, Integer maxWorker, Integer numberGpu, Boolean synchronous, Integer timeout) throws ApiException {
        return this.versionSetAutoScale(modelName, modelVersion, minWorker, maxWorker, numberGpu, synchronous, timeout, Collections.emptyMap());
    }

    public RegisterModel200Response versionSetAutoScale(String modelName, String modelVersion, Integer minWorker, Integer maxWorker, Integer numberGpu, Boolean synchronous, Integer timeout, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (modelName == null) {
            throw new ApiException(400, "Missing the required parameter 'modelName' when calling versionSetAutoScale");
        }
        if (modelVersion == null) {
            throw new ApiException(400, "Missing the required parameter 'modelVersion' when calling versionSetAutoScale");
        }
        String localVarPath = "/models/{model_name}/{model_version}".replaceAll("\\{model_name\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelName))).replaceAll("\\{model_version\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelVersion)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("min_worker", minWorker));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("max_worker", maxWorker));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("number_gpu", numberGpu));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("synchronous", synchronous));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("timeout", timeout));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RegisterModel200Response versionUnregisterModel(String modelName, String modelVersion, Boolean synchronous, Integer timeout) throws ApiException {
        return this.versionUnregisterModel(modelName, modelVersion, synchronous, timeout, Collections.emptyMap());
    }

    public RegisterModel200Response versionUnregisterModel(String modelName, String modelVersion, Boolean synchronous, Integer timeout, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (modelName == null) {
            throw new ApiException(400, "Missing the required parameter 'modelName' when calling versionUnregisterModel");
        }
        if (modelVersion == null) {
            throw new ApiException(400, "Missing the required parameter 'modelVersion' when calling versionUnregisterModel");
        }
        String localVarPath = "/models/{model_name}/{model_version}".replaceAll("\\{model_name\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelName))).replaceAll("\\{model_version\\}", this.apiClient.escapeString(this.apiClient.parameterToString(modelVersion)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("synchronous", synchronous));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("timeout", timeout));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<RegisterModel200Response> localVarReturnType = new TypeReference<RegisterModel200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

