/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tika;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.tika.TikaConfiguration;
import org.apache.camel.component.tika.TikaEndpoint;
import org.apache.camel.support.DefaultComponent;
import org.apache.tika.config.TikaConfig;

@org.apache.camel.spi.annotations.Component(value="tika")
public class TikaComponent
extends DefaultComponent {
    private static final String TIKA_CONFIG = "tikaConfig";

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TikaConfiguration tikaConfiguration = new TikaConfiguration();
        TikaConfig config = (TikaConfig)this.resolveAndRemoveReferenceParameter(parameters, TIKA_CONFIG, TikaConfig.class);
        if (config != null) {
            tikaConfiguration.setTikaConfig(config);
        }
        tikaConfiguration.setOperation(new URI(uri).getHost());
        TikaEndpoint endpoint = this.createEndpoint(uri, tikaConfiguration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected TikaEndpoint createEndpoint(String uri, TikaConfiguration tikaConfiguration) {
        return new TikaEndpoint(uri, (Component)this, tikaConfiguration);
    }
}

