/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.xmpp.services;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.function.Consumer;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.xmpp.common.XmppProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class XmppServerContainer
extends GenericContainer<XmppServerContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmppServerContainer.class);
    private static final String CONTAINER_NAME = "vysper-wrapper";
    private static final Integer PORT_REST = 8080;

    public XmppServerContainer() {
        super(LocalPropertyResolver.getProperty(XmppServerContainer.class, (String)"xmpp.container"));
        this.setWaitStrategy((WaitStrategy)Wait.forListeningPort());
        ((XmppServerContainer)((XmppServerContainer)((XmppServerContainer)this.withExposedPorts(new Integer[]{XmppProperties.PORT_DEFAULT, PORT_REST})).withNetworkAliases(new String[]{CONTAINER_NAME})).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER))).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Started Application in.*", (int)1));
    }

    public XmppServerContainer(boolean fixedPort) {
        this();
        if (fixedPort) {
            this.addFixedExposedPort(XmppProperties.PORT_DEFAULT, XmppProperties.PORT_DEFAULT);
            this.addFixedExposedPort(8088, PORT_REST);
        }
    }

    public String getUrl() {
        return String.format("%s:%d", this.getHost(), this.getMappedPort(XmppProperties.PORT_DEFAULT));
    }

    public void stopXmppEndpoint() throws IOException {
        this.get("stop-tcp");
    }

    public void startXmppEndpoint() throws IOException {
        this.get("start-tcp");
    }

    private void get(String urlAppendix) throws IOException {
        URL url = URI.create(String.format("http://%s:%d/%s", this.getHost(), this.getMappedPort(PORT_REST), urlAppendix)).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.getInputStream();
        conn.disconnect();
    }

    public int getPortDefault() {
        return this.getMappedPort(XmppProperties.PORT_DEFAULT);
    }
}

