/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.triton.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.triton.services.TritonInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class TritonLocalContainerInfraService
implements TritonInfraService,
ContainerService<GenericContainer<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(TritonLocalContainerInfraService.class);
    public static final int HTTP_PORT = 8000;
    public static final int GRPC_PORT = 8001;
    public static final int METRICS_PORT = 8002;
    private static final String CONTAINER_COMMAND = "tritonserver --model-repository=/models";
    private final GenericContainer<?> container;

    public TritonLocalContainerInfraService() {
        String imageName = LocalPropertyResolver.getProperty(TritonLocalContainerInfraService.class, (String)"triton.container");
        this.container = this.initContainer(imageName);
    }

    protected GenericContainer<?> initContainer(String imageName) {
        return new GenericContainer(DockerImageName.parse((String)imageName)).withExposedPorts(new Integer[]{8000, 8001, 8002}).withCopyFileToContainer(MountableFile.forClasspathResource((String)"models"), "/models").waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{8000, 8001, 8002})).withCommand(CONTAINER_COMMAND);
    }

    public void registerProperties() {
        System.setProperty("triton.http.port", String.valueOf(this.httpPort()));
        System.setProperty("triton.grpc.port", String.valueOf(this.grpcPort()));
        System.setProperty("triton.metrics.port", String.valueOf(this.metricsPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the Triton Inference Server container");
        this.container.start();
        this.registerProperties();
        LOG.info("Triton Inference Server instance running at {}, {} and {}", new Object[]{this.httpPort(), this.grpcPort(), this.metricsPort()});
    }

    public void shutdown() {
        LOG.info("Stopping the Triton Inference Server container");
        this.container.stop();
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    @Override
    public int httpPort() {
        return this.container.getMappedPort(8000);
    }

    @Override
    public int grpcPort() {
        return this.container.getMappedPort(8001);
    }

    @Override
    public int metricsPort() {
        return this.container.getMappedPort(8002);
    }
}

