/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.torchserve.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.torchserve.services.TorchServeInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

@InfraService(service=TorchServeInfraService.class, description="TorchServe is a flexible tool for serving PyTorch", serviceAlias={"torch-serve"})
public class TorchServeLocalContainerInfraService
implements TorchServeInfraService,
ContainerService<GenericContainer<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(TorchServeLocalContainerInfraService.class);
    public static final int INFERENCE_PORT = 8080;
    public static final int MANAGEMENT_PORT = 8081;
    public static final int METRICS_PORT = 8082;
    private static final String CONTAINER_COMMAND = "torchserve --ncs --disable-token-auth --enable-model-api --model-store /home/model-server/model-store --models squeezenet1_1.mar";
    private final GenericContainer<?> container;

    public TorchServeLocalContainerInfraService() {
        String imageName = LocalPropertyResolver.getProperty(TorchServeLocalContainerInfraService.class, (String)"torchserve.container");
        this.container = this.initContainer(imageName);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    protected GenericContainer<?> initContainer(final String imageName) {
        class TorchServeContainer
        extends GenericContainer<TorchServeContainer> {
            public TorchServeContainer(boolean fixedPort) {
                super(DockerImageName.parse((String)string));
                ((TorchServeContainer)((TorchServeContainer)((TorchServeContainer)this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"config.properties"), "/home/model-server/config.properties")).withCopyFileToContainer(MountableFile.forClasspathResource((String)"models/squeezenet1_1.mar"), "/home/model-server/model-store/squeezenet1_1.mar")).waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{8080, 8081, 8082}))).withCommand(TorchServeLocalContainerInfraService.CONTAINER_COMMAND);
                if (fixedPort) {
                    this.addFixedExposedPort(8080, 8080);
                    this.addFixedExposedPort(8081, 8081);
                    this.addFixedExposedPort(8082, 8082);
                } else {
                    this.withExposedPorts(new Integer[]{8080, 8081, 8082});
                }
            }
        }
        return new TorchServeContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("torchserve.inference.port", String.valueOf(this.inferencePort()));
        System.setProperty("torchserve.management.port", String.valueOf(this.managementPort()));
        System.setProperty("torchserve.metrics.port", String.valueOf(this.metricsPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the TorchServe container");
        this.container.start();
        this.registerProperties();
        LOG.info("TorchServe instance running at {}, {} and {}", new Object[]{this.inferencePort(), this.managementPort(), this.metricsPort()});
    }

    public void shutdown() {
        LOG.info("Stopping the TorchServe container");
        this.container.stop();
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    @Override
    public int inferencePort() {
        return this.container.getMappedPort(8080);
    }

    @Override
    public int managementPort() {
        return this.container.getMappedPort(8081);
    }

    @Override
    public int metricsPort() {
        return this.container.getMappedPort(8082);
    }
}

