/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.smb.services;

import java.util.concurrent.Future;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;

public class SmbContainer
extends GenericContainer<SmbContainer> {
    public static final int SMB_PORT_DEFAULT = 445;
    public static final String DEFAULT_USER = "camel";
    public static final String DEFAULT_PASSWORD = "camelTester123";

    public SmbContainer(boolean fixedPort) {
        super((Future)new ImageFromDockerfile("localhost/samba:camel", false).withFileFromClasspath(".", "org/apache/camel/test/infra/smb/services/"));
        if (fixedPort) {
            this.addFixedExposedPort(445, 445);
        } else {
            super.withExposedPorts(new Integer[]{445});
        }
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public String getUser() {
        return DEFAULT_USER;
    }

    public String getPassword() {
        return DEFAULT_PASSWORD;
    }

    public String getShare() {
        return "data-rw";
    }

    public int getPort() {
        return this.getMappedPort(445);
    }
}

