/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.smb.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.smb.services.SmbContainer;
import org.apache.camel.test.infra.smb.services.SmbInfraService;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InfraService(service=SmbLocalContainerInfraService.class, description="SAMBA File Server", serviceAlias={"smb"})
public class SmbLocalContainerInfraService
implements SmbInfraService,
ContainerService<SmbContainer> {
    protected static final Logger LOG = LoggerFactory.getLogger(SmbLocalContainerInfraService.class);
    protected final SmbContainer container = new SmbContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));

    public SmbLocalContainerInfraService() {
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    @Override
    public String address() {
        return this.container.getHost() + ":" + this.container.getPort();
    }

    @Override
    public String shareName() {
        return this.container.getShare();
    }

    @Override
    public String userName() {
        return this.container.getUser();
    }

    @Override
    public String password() {
        return this.container.getPassword();
    }

    @Override
    public String smbFile(String file) {
        return (String)this.container.copyFileFromContainer("data/rw/" + file, IOHelper::loadText);
    }

    public SmbContainer getContainer() {
        return this.container;
    }

    public void registerProperties() {
    }

    public void initialize() {
        this.container.start();
        this.registerProperties();
        LOG.info("SMB host running at address {}:", (Object)this.address());
    }

    public void shutdown() {
        LOG.info("Stopping the Smb container");
        this.container.stop();
    }
}

