/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.rocketmq.services;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.rocketmq.services.RocketMQBrokerContainer;
import org.apache.camel.test.infra.rocketmq.services.RocketMQInfraService;
import org.apache.camel.test.infra.rocketmq.services.RocketMQNameserverContainer;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.Network;

@InfraService(service=RocketMQInfraService.class, description="Apache RocketMQ is a distributed messaging and streaming platform", serviceAlias={"rocketmq"})
public class RocketMQContainerInfraService
implements RocketMQInfraService,
ContainerService<RocketMQNameserverContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(RocketMQContainerInfraService.class);
    public static final String ROCKETMQ_VERSION = LocalPropertyResolver.getProperty(RocketMQContainerInfraService.class, (String)"rocketmq.container.image.version");
    public static final String ROCKETMQ_IMAGE = LocalPropertyResolver.getProperty(RocketMQContainerInfraService.class, (String)"rocketmq.container.image") + ":" + ROCKETMQ_VERSION;
    private final RocketMQNameserverContainer nameserverContainer;
    private final RocketMQBrokerContainer brokerContainer1;

    public RocketMQContainerInfraService() {
        Network network = Network.newNetwork();
        this.nameserverContainer = new RocketMQNameserverContainer(network);
        this.brokerContainer1 = new RocketMQBrokerContainer(network, "broker1", ContainerEnvironmentUtil.isFixedPort(this.getClass()));
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.brokerContainer1.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public RocketMQNameserverContainer getContainer() {
        return this.nameserverContainer;
    }

    public void registerProperties() {
    }

    public void initialize() {
        LOG.info("Starting nameserver");
        this.nameserverContainer.start();
        LOG.info("Starting broker");
        this.brokerContainer1.start();
        LOG.info("Apache RocketMQ running at address {}", (Object)this.nameserverAddress());
    }

    public void shutdown() {
        this.brokerContainer1.stop();
        this.nameserverContainer.stop();
    }

    @Override
    public void createTopic(String topic) {
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).until(() -> {
            Container.ExecResult execResult = this.brokerContainer1.execInContainer(new String[]{"sh", "mqadmin", "updateTopic", "-n", "nameserver:9876", "-t", topic, "-c", "DefaultCluster"});
            LOG.info("Exit code: {}. Stderr: {} Stdout: {} ", new Object[]{execResult.getExitCode(), execResult.getStderr(), execResult.getStdout()});
            return execResult.getStdout() != null && execResult.getStdout().contains("success");
        });
    }

    @Override
    public void deleteTopic(String topic) throws IOException, InterruptedException {
        this.brokerContainer1.execInContainer(new String[]{"sh", "mqadmin", "deleteTopic", "-n", "nameserver:9876", "-t", topic});
    }

    @Override
    public String nameserverAddress() {
        return this.nameserverContainer.getHost() + ":" + this.nameserverContainer.getMappedPort(9876);
    }
}

