/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.redis.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.redis.services.RedisContainer;
import org.apache.camel.test.infra.redis.services.RedisInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InfraService(service=RedisInfraService.class, description="In Memory Database", serviceAlias={"redis"})
public class RedisLocalContainerInfraService
implements RedisInfraService,
ContainerService<RedisContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(RedisLocalContainerInfraService.class);
    private final RedisContainer container;

    public RedisLocalContainerInfraService() {
        this.container = new RedisContainer();
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public RedisLocalContainerInfraService(String imageName) {
        this.container = RedisContainer.initContainer(imageName, "redis", ContainerEnvironmentUtil.isFixedPort(this.getClass()));
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public void registerProperties() {
        System.setProperty("redis.service.address", this.getServiceAddress());
        System.setProperty("redis.port", String.valueOf(this.port()));
        System.setProperty("redis.host", this.host());
    }

    public void initialize() {
        LOG.info("Trying to start the Redis container");
        this.container.start();
        this.registerProperties();
        LOG.info("Redis instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Redis container");
        this.container.stop();
    }

    public RedisContainer getContainer() {
        return this.container;
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getMappedPort(6379);
    }
}

