/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.rabbitmq.services;

import org.apache.camel.test.infra.rabbitmq.services.ConnectionProperties;
import org.apache.camel.test.infra.rabbitmq.services.RabbitMQInfraService;

public class RabbitMQRemoteInfraService
implements RabbitMQInfraService {
    @Override
    public ConnectionProperties connectionProperties() {
        return new ConnectionProperties(){

            @Override
            public String username() {
                return System.getProperty("rabbitmq.user.name");
            }

            @Override
            public String password() {
                return System.getProperty("rabbitmq.user.password");
            }

            @Override
            public String hostname() {
                return System.getProperty("rabbitmq.connection.hostname");
            }

            @Override
            public int port() {
                String amqPort = System.getProperty("rabbitmq.connection.amqp", "5672");
                return Integer.parseInt(amqPort);
            }
        };
    }

    @Override
    public int getHttpPort() {
        String httpPort = System.getProperty("rabbitmq.connection.http", "15672");
        return Integer.parseInt(httpPort);
    }

    public void registerProperties() {
    }

    @Override
    public void initialize() {
        this.registerProperties();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String managementUsername() {
        return this.connectionProperties().username();
    }

    @Override
    public String managementPassword() {
        return this.connectionProperties().password();
    }

    @Override
    public String managementUri() {
        return String.format("http://%s:%s", this.connectionProperties().hostname(), this.getHttpPort());
    }
}

