/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.rabbitmq.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.rabbitmq.services.ConnectionProperties;
import org.apache.camel.test.infra.rabbitmq.services.RabbitMQInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.RabbitMQContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=RabbitMQInfraService.class, description="Messaging and streaming broker", serviceAlias={"rabbitmq"})
public class RabbitMQLocalContainerInfraService
implements RabbitMQInfraService,
ContainerService<RabbitMQContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQLocalContainerInfraService.class);
    private final RabbitMQContainer container;

    public RabbitMQLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(RabbitMQLocalContainerInfraService.class, (String)"rabbitmq.container"));
    }

    public RabbitMQLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public RabbitMQLocalContainerInfraService(RabbitMQContainer container) {
        this.container = container;
    }

    protected RabbitMQContainer initContainer(final String imageName) {
        class TestInfraRabbitMQContainer
        extends RabbitMQContainer {
            public TestInfraRabbitMQContainer(boolean fixedPort) {
                super(DockerImageName.parse((String)string).asCompatibleSubstituteFor("rabbitmq"));
                if (fixedPort) {
                    this.addFixedExposedPort(5672, 5672);
                    this.addFixedExposedPort(5671, 5671);
                    this.addFixedExposedPort(15671, 15671);
                    this.addFixedExposedPort(15672, 15672);
                }
            }
        }
        return new TestInfraRabbitMQContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public RabbitMQContainer getContainer() {
        return this.container;
    }

    @Override
    public ConnectionProperties connectionProperties() {
        return new ConnectionProperties(){

            @Override
            public String username() {
                return RabbitMQLocalContainerInfraService.this.container.getAdminUsername();
            }

            @Override
            public String password() {
                return RabbitMQLocalContainerInfraService.this.container.getAdminPassword();
            }

            @Override
            public String hostname() {
                return RabbitMQLocalContainerInfraService.this.container.getHost();
            }

            @Override
            public int port() {
                return RabbitMQLocalContainerInfraService.this.container.getAmqpPort();
            }
        };
    }

    @Override
    public String getAmqpUrl() {
        return this.container.getAmqpUrl();
    }

    @Override
    public int getHttpPort() {
        return this.container.getHttpPort();
    }

    public void registerProperties() {
        ConnectionProperties properties = this.connectionProperties();
        System.setProperty("rabbitmq.user.name", properties.username());
        System.setProperty("rabbitmq.user.password", properties.password());
        System.setProperty("rabbitmq.connection.hostname", properties.hostname());
        System.setProperty("rabbitmq.connection.amqp", String.valueOf(properties.port()));
    }

    @Override
    public void initialize() {
        LOG.info("Trying to start RabbitMQ container");
        this.container.withStartupAttempts(5);
        this.container.start();
        LOG.info("RabbitMQ container running on {}", (Object)this.container.getAmqpUrl());
        this.registerProperties();
    }

    @Override
    public void shutdown() {
        this.container.stop();
    }

    @Override
    public String managementUsername() {
        return this.container.getAdminUsername();
    }

    @Override
    public String managementPassword() {
        return this.container.getAdminPassword();
    }

    @Override
    public String managementUri() {
        return String.format("http://%s:%s", this.container.getHost(), this.container.getHttpPort());
    }
}

