/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.qdrant.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import org.apache.camel.test.infra.common.services.InfrastructureService;

public interface QdrantInfraService
extends InfrastructureService {
    public String getHttpHost();

    public int getHttpPort();

    @Deprecated
    default public String getGrpcHost() {
        return this.host();
    }

    @Deprecated
    default public int getGrpcPort() {
        return this.port();
    }

    public String host();

    public int port();

    default public HttpResponse<byte[]> put(String path, Map<Object, Object> body) throws Exception {
        Object reqPath = !path.startsWith("/") ? "/" + path : path;
        String reqUrl = String.format("http://%s:%d%s", this.getHttpHost(), this.getHttpPort(), reqPath);
        String requestBody = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(body);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(reqUrl)).header("Content-Type", "application/json").PUT(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        return HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofByteArray());
    }
}

