/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.pulsar.services;

import java.time.Duration;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.pulsar.services.PulsarInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.PulsarContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=PulsarInfraService.class, description="Distributed messaging and streaming platform", serviceAlias={"pulsar"})
public class PulsarLocalContainerInfraService
implements PulsarInfraService,
ContainerService<PulsarContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarLocalContainerInfraService.class);
    private final PulsarContainer container;

    public PulsarLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(PulsarLocalContainerInfraService.class, (String)"pulsar.container"));
    }

    public PulsarLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public PulsarLocalContainerInfraService(PulsarContainer container) {
        this.container = container;
    }

    protected PulsarContainer initContainer(String imageName) {
        return (PulsarContainer)new PulsarContainer(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor("apachepulsar/pulsar")).withStartupTimeout(Duration.ofMinutes(3L));
    }

    public void registerProperties() {
        System.setProperty("pulsar.admin.url", this.getPulsarAdminUrl());
        System.setProperty("pulsar.broker.url", this.getPulsarBrokerUrl());
    }

    public void initialize() {
        LOG.info("Trying to start the Pulsar container");
        this.container.start();
        this.registerProperties();
        LOG.info("Pulsar instance running at {}", (Object)this.getPulsarAdminUrl());
        LOG.info("Pulsar admin URL available at {}", (Object)this.getPulsarAdminUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the Pulsar container");
        this.container.stop();
    }

    public PulsarContainer getContainer() {
        return this.container;
    }

    @Override
    public String getPulsarAdminUrl() {
        return this.container.getHttpServiceUrl();
    }

    @Override
    public String getPulsarBrokerUrl() {
        return this.container.getPulsarBrokerUrl();
    }
}

