/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.opensearch.services;

import java.time.Duration;
import java.util.function.Consumer;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.opensearch.services.OpenSearchInfraService;
import org.opensearch.testcontainers.OpensearchContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class OpenSearchLocalContainerInfraService
implements OpenSearchInfraService,
ContainerService<OpensearchContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchLocalContainerInfraService.class);
    private static final int OPEN_SEARCH_PORT = 9200;
    private static final String USER_NAME = "admin";
    private static final String PASSWORD = "admin";
    private final OpensearchContainer container;

    public OpenSearchLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(OpenSearchLocalContainerInfraService.class, (String)"opensearch.container"));
    }

    public OpenSearchLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public OpenSearchLocalContainerInfraService(OpensearchContainer container) {
        this.container = container;
    }

    protected OpensearchContainer initContainer(String imageName) {
        DockerImageName customImage = DockerImageName.parse((String)imageName).asCompatibleSubstituteFor("opensearchproject/opensearch");
        OpensearchContainer opensearchContainer = new OpensearchContainer(customImage);
        opensearchContainer.setWaitStrategy(new LogMessageWaitStrategy().withRegEx(".*(\"message\":\\s?\"started[\\s?|\"].*|] started\n$)").withStartupTimeout(Duration.ofSeconds(90L)));
        opensearchContainer.withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));
        return opensearchContainer;
    }

    @Override
    public int getPort() {
        return this.container.getMappedPort(9200);
    }

    @Override
    public String getOpenSearchHost() {
        return this.container.getHost();
    }

    @Override
    public String getHttpHostAddress() {
        return this.container.getHttpHostAddress();
    }

    public void registerProperties() {
        System.setProperty("opensearch.host", this.getOpenSearchHost());
        System.setProperty("opensearch.port", String.valueOf(this.getPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the OpenSearch container");
        ContainerEnvironmentUtil.configureContainerStartup((GenericContainer)this.container, (String)"opensearch.container.startup.attempts", (int)2);
        this.container.start();
        this.registerProperties();
        LOG.info("OpenSearch instance running at {}", (Object)this.getHttpHostAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the OpenSearch container");
        this.container.stop();
    }

    public OpensearchContainer getContainer() {
        return this.container;
    }

    @Override
    public String getUsername() {
        return "admin";
    }

    @Override
    public String getPassword() {
        return "admin";
    }
}

