/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openldap.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.openldap.services.OpenLdapContainer;
import org.apache.camel.test.infra.openldap.services.OpenldapInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InfraService(service=OpenldapInfraService.class, description="OpenLDAP is an implementation of the Lightweight Directory Access Protocol", serviceAlias={"openldap"})
public class OpenldapLocalContainerInfraService
implements OpenldapInfraService,
ContainerService<OpenLdapContainer> {
    public static final int CONTAINER_PORT_LDAP = 389;
    public static final int CONTAINER_PORT_LDAP_OVER_SSL = 636;
    private static final Logger LOG = LoggerFactory.getLogger(OpenldapLocalContainerInfraService.class);
    private final OpenLdapContainer container = new OpenLdapContainer();

    public void registerProperties() {
        System.setProperty("openldap.port.ldap", String.valueOf(this.getPort()));
        System.setProperty("openldap.port.ldap.ssl", String.valueOf(this.getSslPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the Openldap container");
        this.container.start();
        this.registerProperties();
        LOG.info("Openldap instance running at {}", (Object)this.getPort());
    }

    public void shutdown() {
        LOG.info("Stopping the Openldap container");
        this.container.stop();
    }

    public OpenLdapContainer getContainer() {
        return this.container;
    }

    @Override
    public Integer getPort() {
        return this.container.getMappedPort(389);
    }

    @Override
    public Integer getSslPort() {
        return this.container.getMappedPort(636);
    }

    @Override
    public String getHost() {
        return this.container.getHost();
    }
}

