/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openai.mock;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.test.infra.openai.mock.ToolExecutionStep;

public class ToolExecutionSequence {
    private final List<ToolExecutionStep> steps = new ArrayList<ToolExecutionStep>();
    private int currentStepIndex = 0;

    public void addStep(ToolExecutionStep step) {
        this.steps.add(step);
    }

    public ToolExecutionStep getCurrentStep() {
        if (this.hasCurrentStep()) {
            return this.steps.get(this.currentStepIndex);
        }
        return new ToolExecutionStep();
    }

    public void advanceToNextStep() {
        ++this.currentStepIndex;
    }

    public boolean hasCurrentStep() {
        return this.currentStepIndex < this.steps.size();
    }

    public boolean hasMoreSteps() {
        return this.currentStepIndex < this.steps.size();
    }

    public boolean isInProgress() {
        return this.currentStepIndex > 0 && this.currentStepIndex < this.steps.size();
    }

    public void reset() {
        this.currentStepIndex = 0;
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    public int getTotalSteps() {
        return this.steps.size();
    }

    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }
}

