/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openai.mock;

import com.sun.net.httpserver.HttpExchange;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.camel.test.infra.openai.mock.MockExpectation;
import org.apache.camel.test.infra.openai.mock.OpenAIMock;
import org.apache.camel.test.infra.openai.mock.ToolCallDefinition;
import org.apache.camel.test.infra.openai.mock.ToolExecutionStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIMockBuilder {
    private static final Logger log = LoggerFactory.getLogger(OpenAIMockBuilder.class);
    private final OpenAIMock mock;
    private final List<MockExpectation> expectations;
    private MockExpectation currentExpectation;

    public OpenAIMockBuilder(OpenAIMock mock, List<MockExpectation> expectations) {
        this.mock = mock;
        this.expectations = expectations;
    }

    public OpenAIMockBuilder when(String expectedInput) {
        log.debug("Setting up expectation for input: {}", (Object)expectedInput);
        this.currentExpectation = new MockExpectation(expectedInput);
        return this;
    }

    public OpenAIMockBuilder replyWith(String expectedResponse) {
        this.validateCurrentExpectation("replyWith()");
        log.debug("Setting expected response: {}", (Object)expectedResponse);
        this.currentExpectation.setExpectedResponse(expectedResponse);
        return this;
    }

    public OpenAIMockBuilder replyWithToolContent(String customMessage) {
        this.validateCurrentExpectation("replyWithToolContent()");
        log.debug("Setting tool content response with custom message: {}", (Object)customMessage);
        this.currentExpectation.setToolContentResponse(customMessage);
        return this;
    }

    public OpenAIMockBuilder invokeTool(String toolName) {
        this.validateCurrentExpectation("invokeTool()");
        log.debug("Adding new tool execution step with tool: {}", (Object)toolName);
        ToolExecutionStep newStep = new ToolExecutionStep();
        newStep.addToolCall(new ToolCallDefinition(toolName));
        this.currentExpectation.addToolExecutionStep(newStep);
        return this;
    }

    public OpenAIMockBuilder andInvokeTool(String toolName) {
        this.validateCurrentExpectation("andInvokeTool()");
        this.validateHasToolSteps("andInvokeTool()");
        log.debug("Adding parallel tool to current step: {}", (Object)toolName);
        ToolExecutionStep currentStep = this.currentExpectation.getCurrentToolStep();
        currentStep.addToolCall(new ToolCallDefinition(toolName));
        return this;
    }

    public OpenAIMockBuilder withParam(String key, Object value) {
        this.validateCurrentExpectation("withParam()");
        this.validateHasToolSteps("withParam()");
        ToolExecutionStep currentStep = this.currentExpectation.getCurrentToolStep();
        if (currentStep.isEmpty()) {
            throw new IllegalStateException("No tool calls in current step to add parameters to");
        }
        ToolCallDefinition lastTool = currentStep.getLastToolCall();
        log.debug("Adding parameter {} = {} to tool: {}", new Object[]{key, value, lastTool.getName()});
        lastTool.addArgument(key, value);
        return this;
    }

    public OpenAIMockBuilder thenRespondWith(BiFunction<HttpExchange, String, String> responseFunction) {
        this.validateCurrentExpectation("thenRespondWith()");
        log.debug("Setting custom response function");
        this.currentExpectation.setCustomResponseFunction(responseFunction);
        return this;
    }

    public OpenAIMockBuilder assertRequest(Consumer<String> requestAssertion) {
        this.validateCurrentExpectation("assertRequest()");
        log.debug("Setting request assertion");
        this.currentExpectation.setRequestAssertion(requestAssertion);
        return this;
    }

    public OpenAIMockBuilder andThenInvokeTool(String toolName) {
        this.validateCurrentExpectation("andThenInvokeTool()");
        this.validateHasToolSteps("andThenInvokeTool()");
        log.debug("Creating new sequential step with tool: {}", (Object)toolName);
        ToolExecutionStep newStep = new ToolExecutionStep();
        newStep.addToolCall(new ToolCallDefinition(toolName));
        this.currentExpectation.addToolExecutionStep(newStep);
        this.currentExpectation.advanceToNextToolStep();
        return this;
    }

    public OpenAIMockBuilder end() {
        this.validateCurrentExpectation("end()");
        log.debug("Finalizing expectation for input: {}", (Object)this.currentExpectation.getExpectedInput());
        this.expectations.add(this.currentExpectation);
        this.currentExpectation = null;
        return this;
    }

    public OpenAIMock build() {
        if (this.currentExpectation != null) {
            log.debug("Auto-finalizing current expectation during build");
            this.expectations.add(this.currentExpectation);
            this.currentExpectation = null;
        }
        log.info("Built OpenAIMock with {} expectations", (Object)this.expectations.size());
        return this.mock;
    }

    private void validateCurrentExpectation(String methodName) {
        if (this.currentExpectation == null) {
            throw new IllegalStateException("Call when() before " + methodName);
        }
    }

    private void validateHasToolSteps(String methodName) {
        if (this.currentExpectation.getToolSequence().isEmpty()) {
            throw new IllegalStateException("Call invokeTool() before " + methodName);
        }
    }
}

